﻿/**
FormulaMethod.Math.RoundDownNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Math
{
    public class RoundDownNode : AbstractMethodNode
    {
        private static string[] signature = { "rounddown" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode), typeof(NumberNode) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"第一引数を第二引数の桁で切り捨てます。

例)
rounddown(456.456 , -3) = 0
rounddown(456.456 , -2) = 400
rounddown(456.456 , -1) = 450
rounddown(456.456 , 0)  = 456
rounddown(456.456 , 1)  = 456.4
rounddown(456.456 , 2)  = 456.45
rounddown(456.456 , 3)  = 456.456
rounddown(456.456 , 4)  = 456.456
"; } }
        protected override INode execute()
        {

            decimal value = 0m;
            //decimal? tmp = ((IValueNode)this.FormatArgs[0].eval()).getDecimal();
            decimal? tmp = ((IValueNode)this.getArgsAlready(0)).getDecimal();
            //decimal? keta = this.FormatArgs.Count <= 1 ? 0m : ((IValueNode)this.FormatArgs[1].eval()).getDecimal();
            decimal? keta = this.FormatArgs.Count <= 1 ? 0m : ((IValueNode)this.getArgsAlready(1)).getDecimal();

            //if (keta >= 0)
            //    value = decimal.Round(tmp ?? 0m , (int)(keta ?? 0) , MidpointRounding.AwayFromZero);
            //else
            //{
            double t = (double)tmp;
            double k = System.Math.Abs(System.Math.Pow(10, -1 * (double)keta));
            t = t / k;
            t = System.Math.Floor(System.Math.Abs(t)) * k * (t > 0 ? 1 : -1);
            value = (decimal) t;
            //}

            NumberNode ret = new NumberNode();
            ret.Value = value;

            return ret;
        }

    }
}
