﻿/**
FormulaMethod.Math.MaxNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Math
{
    public class MaxNode : AbstractMethodNode
    {
        private static string[] signature = { "max" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode[]) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"引数の最大値を返します。
"; } }
        protected override INode execute()
        {
            decimal? value = null;
            //foreach(INode node in this.FormatArgs)
            for (int i = 0 ; i < this.FormatArgs.Count; i++)
            {
                //decimal? arg = ((IValueNode)node.eval()).getDecimal();
                decimal? arg = ((IValueNode)this.getArgsAlready(i)).getDecimal();
                if (arg != null)
                    value = (value == null || value < (decimal)arg ) ? (decimal)arg : value;
            }
            NumberNode ret = new NumberNode();
            ret.Value = value;

            return ret;
        }

    }
}
