﻿/**
FormulaMethod.Math.AverageNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Math
{
    public class AverageNode : AbstractMethodNode
    {
        private static string[] signature = { "average" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode[]) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"引数の平均値を返します
"; } }
        protected override INode execute()
        {

            int counter = 0;
            decimal value = 0m;
            //foreach (INode node in this.FormatArgs)
            for(int i = 0; i <  this.FormatArgs.Count; i++)
            {
                //decimal? arg = ((IValueNode)node.eval()).getDecimal();
                decimal? arg = ((IValueNode)this.getArgsAlready(i)).getDecimal();
                if(arg != null)
                {
                    counter++;
                    value += (decimal)arg;
                }
            }
            NumberNode ret = new NumberNode();
            ret.Value = counter == 0 ? 0m : value / counter;

            return ret;
        }

    }
}
