﻿/**
FormulaMethod.Logical.OrNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Logical
{
    public class OrNode : AbstractMethodNode
    {
        private static string[] signature = { "or" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(BoolNode[]) }; } }
        public override Type ReturnNode { get { return typeof(BoolNode); } }
        public override string Note { get { return @"引数をすべてTrue/Falseとして評価し、
そのいずれかがTrueのときにTrueを返します。

引数は一つ以上である必要があります。
"; } }
        protected override INode execute()
        {

            bool b = false;
            //foreach (INode node in this.FormatArgs)
            for(int i = 0; i < this.FormatArgs.Count; i++)
            {
                INode node = this.getArgsAlready(i);
                //if (((IValueNode)node.eval()).getBoolean())
                if(((IValueNode)node).getBoolean())
                { 
                    b = true;
                    break;
                }
            }
            BoolNode ret = new BoolNode();
            ret.Value = b;

            return ret;
        }

    }
}
