﻿/**
FormulaMethod.Logical.IfNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;

using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;

namespace FormulaMethod.Logical
{
    public class IfNode : AbstractMethodNode
    {
        private static string[] signature = { "if" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(BoolNode), typeof(IValueNode), typeof(IValueNode)   }; } }
        public override Type ReturnNode { get { return typeof(IValueNode); } }
        public override string Note { get { return @"第一引数を条件とし、
第一引数の結果がTrueのとき、第二引数が実行されます。
第一引数の結果がFalseのとき、第三引数が実行されます。
"; } }
        protected override INode execute()
        {

            INode ret = null;

            if (this.FormatArgs.Count < 2)
                throw new ArgumentException();
            //INode formula = this.FormatArgs[0];
            INode formula = this.getArgsAlready(0);
            if (((IValueNode)formula).getBoolean())
                //ret = this.FormatArgs[1].eval();
                ret = this.getArgsAlready(1);
            else if (this.FormatArgs.Count > 2)
                //ret = this.FormatArgs[2].eval();
                ret = this.getArgsAlready(2);
            else
                ret = new WordNode();
            
            return ret;
        }

    }
}
