﻿/**
FormulaMethod.String.TodayNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Date
{
    public class TodayNode : AbstractMethodNode
    {

        private static string[] signature = { "today" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] {}; } }
        public override Type ReturnNode { get { return typeof(FormulaOperator.Variable.DateTimeNode); } }
        public override string Note { get { return @"実行日を取得します。
実行日時とは関数単体が実行された時点を指します。
処理中に日付が変更された場合、結果が異なる場合があります。
"; } }
        protected override INode execute()
        {
            INode ret = null;
            string s = "";

            ret = new FormulaOperator.Variable.DateTimeNode();
            ((FormulaOperator.Variable.DateTimeNode)ret).Value = DateTime.Today;
            
            return ret;
        }



    }
}
