﻿/**
FormulaMethod.String.TodayNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Date
{
    public class SecondNode : AbstractMethodNode
    {

        private static string[] signature = { "second" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] {typeof(DateTimeNode)}; } }
        public override Type ReturnNode { get { return typeof(FormulaOperator.Variable.NumberNode); } }
        public override string Note { get { return @"日時から秒(0～59)を返します。
"; } }
        protected override INode execute()
        {
            INode ret = null;
            string s = "";
            if (this.FormatArgs.Count != 1)
                throw new ArgumentException();

            //DateTimeNode d = ((DateTimeNode)this.FormatArgs[0].eval());
            DateTimeNode d = (DateTimeNode)this.getArgsAlready(0);
            if (d.value == null)
                throw new ArgumentException();

            DateTime t = (DateTime)d.Value;
            
            ret = new FormulaOperator.Variable.NumberNode();
            ((FormulaOperator.Variable.NumberNode)ret).Value = ((DateTime)d.Value).Second;
            
            return ret;
        }



    }
}
