﻿/**
FormulaMethod.String.DatedIfNode

Copyright (c) 2016 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Date
{
    public class DatedIfNode : AbstractMethodNode
    {

        private static string[] signature = { "datedif" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(DateTimeNode), typeof(DateTimeNode), typeof(WordNode) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"日付の引き算を行います。
第一引数：引く日付
第二引数：引かれる日付
第三引数：区分(Y,M,D,YM,DM,YDのいずれか)

年齢の計算などに使用します。
今日の年齢を計算する場合以下です。
datedif(誕生日,今日,""Y"")

例)誕生日が2001/2/3の人の2015/2/2時点の年齢
datedif(date(2001,2,3),date(2015,2,2),""Y"")

区分に指定した内容により結果は以下のように変化します。
　Y　　年数
　M　　月数
　D　　日数
　MD　 1カ月未満の日数
　YM 　1年未満の月数
　YD 　1年未満の日数
"; } }
        protected override INode execute()
        {
            INode ret = null;
            string s = "";
            if (this.FormatArgs.Count != 3)
                throw new ArgumentException();

            DateTimeNode fn = (DateTimeNode)this.getArgsAlready(0);// ((DateTimeNode)this.FormatArgs[0].eval());
            DateTimeNode tn = (DateTimeNode)this.getArgsAlready(1);// ((DateTimeNode)this.FormatArgs[1].eval());
            WordNode bn = (WordNode)this.getArgsAlready(2);//((WordNode)this.FormatArgs[2].eval());

            DateTime f = (DateTime)fn.Value;
            DateTime t = (DateTime)tn.Value;
            string b = bn.Value.ToString().ToUpper();
            int r = 0;

            ret = new FormulaOperator.Variable.NumberNode();
            ((FormulaOperator.Variable.NumberNode)ret).Value = this.diff(f, t, b);

            return ret;
        }

        private int diff(DateTime from, DateTime to, string unit)
        {
            int y1 = from.Year;
            int m1 = from.Month;
            int d1 = from.Day;
            int y2 = to.Year;
            int m2 = to.Month;
            int d2 = to.Day;

            int ret = 0;


            if ("Y" == unit)
            {
                ret = this.diff(from, to, "M") / 12;
                if (ret < 0)
                    ret = -1 * System.Math.Abs(ret);
                else
                    ret = System.Math.Abs(ret);
            }
            else if ("M" == unit)
            {
                ret = (y2 * 12 + m2) - (y1 * 12 + m1);
                DateTime t = from.AddMonths(ret);
                if ((to - t).Days < 0)
                    ret -= 1;
            }
            else if ("D" == unit)
            {
                ret = (to-from).Days;
            }
            else if ("YM" == unit)
            {
                ret = this.diff(from, to, "M") % 12;
            }
            else if ("MD" == unit)
            {
                DateTime t = from.AddMonths(this.diff(from, to, "M"));
                ret = (to - t).Days;
            }
            else if ("YD" == unit)
            {
                DateTime t = from.AddYears(this.diff(from, to, "Y"));
                ret = (to - t).Days;
            }
            else
            {
                throw new ArgumentException();
            }
            return ret;

        }
    }
}
