﻿/**
FormulaMethod.String.DateNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Date
{
    public class DateNode : AbstractMethodNode
    {
        private static string[] signature = { "date" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] {
            typeof(IValueNode) 
            ,typeof(IValueNode)
            ,typeof(IValueNode)
            ,typeof(IValueNode)
            ,typeof(IValueNode)
            ,typeof(IValueNode)
            ,typeof(IValueNode)
        }; } }
        public override Type ReturnNode { get { return typeof(FormulaOperator.Variable.DateTimeNode); } }
        public override string Note { get { return @"日付を作成します。
下記3パターンの引数で作成します。
パターン①：日付文字列を設定
　第一引数：日付文字列
パターン②：年月日のみ指定
　第１引数：年
　第２引数：月
　第３引数：日
パターン③：②に加えて時分秒を指定
　第１引数：年
　第２引数：月
　第３引数：日
　第４引数：時
　第５引数：分
　第６引数：秒
パターン④：③に加えてミリ秒を指定
　第１引数：年
　第２引数：月
　第３引数：日
　第４引数：時
　第５引数：分
　第６引数：秒
　第７引数：ミリ秒

時分秒のみ、ミリ秒のみという指定はできません。
時分秒を省略した場合、00:00:00と解釈されます。

パターン①の場合、以下のいずれかの書式で日付文字列を設定します。
　yyyy/mm/dd　　　　　　2015/03/12
　yyyy/mm/dd hh:nn:ss   2000/12/03 23:14:00

例）
date(""2015/1/2"") = 2015/01/02
date(""2014/3/2 23:11:30"") = 2014/03/02 23:11:30
date(2015,1,2) = 2015/01/02
date(2014,3,2,23,11,30) = 2014/03/02 23:11:30
date(2013,10,23,3,2,40,1234) = 2013/10/23 03:02:40.1234
"; } }
        protected override INode execute()
        {
            INode ret = null;
            string s = "";
            if (this.FormatArgs.Count == 1)
            {
                //throw new ArgumentException();
                s = ((IValueNode)this.FormatArgs[0].eval()).Value.ToString();
            }
            else if (this.FormatArgs.Count == 3)
            {
                s = string.Format("{0}/{1}/{2}"
                    , ((IValueNode)this.getArgsAlready(0)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(1)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(2)).Value.ToString());
                    //, ((IValueNode)this.FormatArgs[0].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[1].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[2].eval()).Value.ToString());
            }
            else if (this.FormatArgs.Count == 6)
            {
                s = string.Format("{0}/{1}/{2} {3}:{4}:{5}"
                    , ((IValueNode)this.getArgsAlready(0)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(1)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(2)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(3)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(4)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(5)).Value.ToString());
                    //, ((IValueNode)this.FormatArgs[0].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[1].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[2].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[3].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[4].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[5].eval()).Value.ToString());
            }
            else if (this.FormatArgs.Count == 7)
            {
                s = string.Format("{0}/{1}/{2} {3}:{4}:{5}.{6}"
                    , ((IValueNode)this.getArgsAlready(0)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(1)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(2)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(3)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(4)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(5)).Value.ToString()
                    , ((IValueNode)this.getArgsAlready(6)).Value.ToString());
                    //, ((IValueNode)this.FormatArgs[0].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[1].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[2].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[3].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[4].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[5].eval()).Value.ToString()
                    //, ((IValueNode)this.FormatArgs[6].eval()).Value.ToString());
            }
            ret = new FormulaOperator.Variable.DateTimeNode();
            DateTime v;
            if (DateTime.TryParse(s, out v))
                ((FormulaOperator.Variable.DateTimeNode)ret).Value = v;
            else
                ret = null;
            return ret;
        }



    }
}
