﻿/**
FormulaMethod.String.DateAddNode

Copyright (c) 2016 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Date
{
    public class DateAddNode : AbstractMethodNode
    {

        private static string[] signature = { "dateadd" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] {typeof(WordNode), typeof(NumberNode), typeof(DateTimeNode) }; } }
        public override Type ReturnNode { get { return typeof(DateTimeNode); } }
        public override string Note { get { return @"日付の足し算を行います。
第一引数：区分(y,m,d,h,n,s)
第二引数：数値、年/月/日/時/分/秒
第三引数：日付

第一引数の区分により第二引数を第三引数に足すときの箇所を変更します。
y：年
m：月
d：日
h：時
n：分
s：秒

引き算をする場合は第二引数を負の数にします。

例)
2015/03/02 23:20:03の一年後
dateadd(""y"" , 1 , date(2015,3,2,23,20,3))

2015/03/02 23:20:03の一分前
dateadd(""n"" , -1 , date(2015,3,2,23,20,3))

"; } }
        protected override INode execute()
        {
            INode ret = null;
            string s = "";
            if (this.FormatArgs.Count != 3)
                throw new ArgumentException();

            WordNode div = (WordNode)this.getArgsAlready(0);// this.FormatArgs[0].eval();
            NumberNode interval = (NumberNode)this.getArgsAlready(1);// this.FormatArgs[1].eval());
            DateTimeNode tn = (DateTimeNode)this.getArgsAlready(2);// this.FormatArgs[2].eval());

            string d = ((string)div.Value).ToLower();
            decimal i = interval.getDecimal().Value;
            DateTime t = (DateTime)tn.Value;

            if ("y" == d)
                t = t.AddYears((int)i);
            else if ("m" == d)
                t = t.AddMonths((int)i);
            else if ("d" == d)
                t = t.AddDays((int)i);
            else if ("h" == d)
                t = t.AddHours((int)i);
            else if ("n" == d)
                t = t.AddMinutes((int)i);
            else if ("s" == d)
                t = t.AddSeconds((int)i);
            else
                throw new ArgumentException();

            ret = new DateTimeNode();
            ((DateTimeNode)ret).Value = t;

            return ret;
        }

    }


}
