﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FormulaDebugger.Utility
{
    /// <summary>
    /// リストの無限ループを実現するためのクラス
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public class LoopList<T> : IEnumerable<T>, IEnumerator<T>
    {
        /// <summary>
        /// ループする対象のリスト
        /// </summary>
        public List<T> list;
        /// <summary>
        /// 現在位置
        /// </summary>
        private int position;
        /// <summary>
        /// 現在位置
        /// </summary>
        private T _current;
        /// <summary>
        /// 現在位置
        /// </summary>
        public T Current { get { return _current; } }
        /// <summary>
        /// 現在位置
        /// </summary>
        object IEnumerator.Current { get { return _current; } }
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LoopList()
        {
            this.Reset();
        }
        public void Dispose()
        {
            //throw new NotImplementedException();
        }
        /// <summary>
        /// 次に移動(常時TRUE)
        /// </summary>
        /// <returns></returns>
        public bool MoveNext()
        {
            this._current = this.list[this.position++];
            if (this.list.Count <= this.position)
                this.Reset();
            return true;
        }
        /// <summary>
        /// 初期状態に戻す
        /// </summary>
        public void Reset()
        {
            this.position = 0;
        }

        public IEnumerator<T> GetEnumerator() { return this; }
        IEnumerator IEnumerable.GetEnumerator() { return this; }
    }
}
