﻿using FormulaDebugger.Utility;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FormulaDebugger.Utility
{
    /// <summary>
    /// 色を取得します。
    /// コンストラクタで設定された色を
    /// getNextColor()により順次取得します。
    /// 内容は無限ループで返されます
    /// </summary>
    public class ColorUtility
    {
        /// <summary>
        /// 色リスト
        /// </summary>
        private LoopList<Color> list;
        /// <summary>
        /// インスタンス
        /// </summary>
        private static ColorUtility utility = null;
        /// <summary>
        /// インスタンスを取得します
        /// </summary>
        /// <returns></returns>
        public static ColorUtility getInstance()
        {
            if (utility == null)
                utility = new ColorUtility();
            return utility;
        }
        /// <summary>
        /// コンストラクタ
        /// </summary>
        private ColorUtility()
        {
            this.list = new LoopList<Color>();
            this.list.list = new List<Color>();
            this.list.list.Add(Color.LightCoral);
            this.list.list.Add(Color.Turquoise);
            this.list.list.Add(Color.CornflowerBlue);
            this.list.list.Add(Color.MediumOrchid);
            this.list.list.Add(Color.DarkKhaki);
            this.list.list.Add(Color.PaleVioletRed);
            this.list.list.Add(Color.MediumAquamarine);
            this.list.list.Add(Color.RosyBrown);
            this.list.list.Add(Color.DarkSeaGreen);
        }
        /// <summary>
        /// 次の色を返します
        /// </summary>
        /// <returns></returns>
        public Color getNextColor()
        {
            list.MoveNext();
            return list.Current;
        }
        /// <summary>
        /// ループをリセットします
        /// </summary>
        public void Reset()
        {
            this.list.Reset();
        }
    }
}
