﻿/**
FormulaDebugger.SyntaxhighlighterMode

Copyright (c) 2016 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

namespace FormulaDebugger
{
    /// <summary>
    /// シンタックスハイライトの動作モードを示す列挙型
    /// </summary>
    public enum SyntaxhighlighterMode : int
    {
        /// <summary>
        /// テキストが変更されるたびにシンタックスハイライトの処理が走ります
        /// </summary>
        Every,
        /// <summary>
        /// テキストが変更されたあと、一定時間経過後、シンタックスハイライトの処理が走ります。
        /// タイマーはテキストが変更されるたびにリセットされます。
        /// シンタックスハイライトの処理が始まるまでの時間はTimerIntervalで指定します。
        /// </summary>
        Timer
    }
}
