﻿/**
Formula.Word

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

namespace Formula
{
    /// <summary>
    /// 一つの単語を示します
    /// </summary>
    public class Word
    {
        /// <summary>
        /// 元の式における単語の開始位置
        /// </summary>
        public int startPosition { get; set; }
        /// <summary>
        /// 元の式における単語の終了位置
        /// </summary>
        public int endPosition { get; set; }
        /// <summary>
        /// 単語(元文字列がダブルクォートでくくられていた場合、ダブルクォートを除く単語)
        /// </summary>
        public object word { get; set; }
        /// <summary>
        /// 単語がダブルクォートで囲われていたか
        /// </summary>
        public bool isBlock { get; set; }

        public override string ToString()
        {
            return string.Format("{0} [{1}-{2}]", this.word, this.startPosition, this.endPosition);
        }
    }
}
