﻿/**
Formula.StepExecuteVisitor

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using System.Collections.Generic;

namespace Formula
{
    /// <summary>
    /// ステップ実行を行います。
    /// すでに構築された構文木を通常のルートで処理をします。
    /// 一つ処理をすると処理が戻ります。
    /// </summary>
    public class StepExecuteVisitor
    {
        /// <summary>
        /// 処理対象のノード
        /// </summary>
        public INode currentNode { get; set; }
        /// <summary>
        /// 処理後のノードID
        /// </summary>
        public int replaceToId { get; set; }
        /// <summary>
        /// 処理前のノードID(処理後は存在しない)
        /// </summary>
        public int replaceFromId { get; set; }
        
        /// <summary>
        /// 実行します。
        /// </summary>
        /// <param name="currentNode">処理対象となるノード</param>
        /// <param name="isUpdate">True:ノードを処理し、構文木を再構築する False:処理対象ノードを特定するだけで再構築はしない</param>
        public INode Execute(INode currentNode ,  bool isUpdate = true)
        {
            //int ret = -1;
            this.replaceToId = -1;
            this.replaceFromId = -1;
            this.currentNode = currentNode;

            List<INode> args = null;
            if (this.currentNode is IMethodNode)
            {
                args = ((IMethodNode)this.currentNode).FormatArgs;
                ((IMethodNode)currentNode).Args.Clear();
                foreach (INode node in args)
                    ((IMethodNode)currentNode).Args.Add(node);
            }
            if (this.currentNode is IFunctionNode)
                args = ((IFunctionNode)currentNode).Args;
            if (args != null)
            {
                //==============================================
                //子ノードに未計算のものがある場合、計算を行う。
                //==============================================
                //子ノードがすべて「値」かどうかを判別する
                bool isBase = true;
                foreach (INode node in args)
                {
                    if (node == null) continue;
                    //内部メソッドが既に実行済みの場合は値扱いする
                    isBase &= node is IValueNode
                        || (node is InnerMethodNode && ((InnerMethodNode)node).IsAlreadyExec());
                }
                //子ノードに「値」以外がある場合、計算する
                if (!isBase)
                {
                    for (int i = 0; i < args.Count; i++)
                    //for (int i = 0; i < ((IFunctionNode)currentNode).Args.Count; i++)
                    //foreach (INode node in ((IFunctionNode)currentNode).Args)
                    {
                        //INode node = ((IFunctionNode)currentNode).Args[i];
                        INode node = args[i];
                        StepExecuteVisitor visitor = new StepExecuteVisitor();
                        ((IFunctionNode)currentNode).Args[i] = visitor.Execute(node, isUpdate);
                        this.replaceToId = visitor.replaceToId;
                        this.replaceFromId = visitor.replaceFromId;
                        if (this.replaceToId > 0)
                            break;
                    }
                    return this.currentNode;
                }

                //子ノード以下の実行結果でもって現在のノードを置き換える
                this.replaceFromId = this.currentNode.nodeId;
                INode resultNode = this.currentNode.eval();
                this.replaceToId = resultNode.nodeId;

                return resultNode;

            }
            //if (this.currentNode is IMethodNode)
            //{
                
            //}
            //else if (this.currentNode is IFunctionNode)
            //{
            //    //==============================================
            //    //子ノードに未計算のものがある場合、計算を行う。
            //    //==============================================
            //    //子ノードがすべて「値」かどうかを判別する
            //    bool isBase = true;
            //    foreach (INode node in ((IFunctionNode)currentNode).Args)
            //    {
            //        if (node == null) continue;
            //        //内部メソッドが既に実行済みの場合は値扱いする
            //        isBase &= node is IValueNode
            //            || ( node is InnerMethodNode && ((InnerMethodNode)node).IsAlreadyExec() );
            //    }
            //    //子ノードに「値」以外がある場合、計算する
            //    if (!isBase)
            //    {
            //        for (int i =0; i < ((IFunctionNode)currentNode).Args.Count; i++)
            //        //foreach (INode node in ((IFunctionNode)currentNode).Args)
            //        {
            //            INode node = ((IFunctionNode)currentNode).Args[i];
            //            StepExecuteVisitor visitor = new StepExecuteVisitor();
            //            ((IFunctionNode)currentNode).Args[i] = visitor.Execute(node  , isUpdate);
            //            this.replaceToId = visitor.replaceToId;
            //            this.replaceFromId = visitor.replaceFromId;
            //            if (this.replaceToId > 0)
            //                break;
            //        }
            //        return this.currentNode;
            //    }

            //    //子ノード以下の実行結果でもって現在のノードを置き換える
            //    this.replaceFromId = this.currentNode.nodeId;
            //    INode resultNode = this.currentNode.eval();
            //    this.replaceToId = resultNode.nodeId;

            //    return resultNode;

            //}
            return this.currentNode.eval();
        }
    }
}
