﻿/**
Formula.ParentSetVisitor

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;

namespace Formula
{
    /// <summary>
    /// 構文木の親子関係をリセットします。
    /// (FormulaParserで構築された構文木は「親」がだれかを持たない為)
    /// ※InnerMethodOptimizer使用後は使用しないでください。
    /// 当該Optimizerで使用されるInnerMethodNodeは親を持たないため、処理結果が不正となります。
    /// </summary>
    public class ParentSetVisitor
    {
        public INode parentNode { get; set; }
        public INode currentNode { get; set; }
        public void visit()
        {
            if (currentNode == null) return;
            currentNode.ParentNode = this.parentNode;
            if (currentNode is IFunctionNode)
            {
                foreach (INode node in ((IFunctionNode)currentNode).Args)
                {
                    if (node == null) continue;
                    ParentSetVisitor visitor = new ParentSetVisitor();
                    visitor.parentNode = this.currentNode;
                    visitor.currentNode = node;
                    visitor.visit();
                }
            }
        }
    }
}
