﻿/**
Formula.Optimizer.NodeVisitor

Copyright (c) 2016 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Formula.Node;
using Formula.Node.Impl;

namespace Formula.Optimizer.InnerMethodOptimizer
{
    /// <summary>
    /// 構文木を枝単位に分解します。
    /// 基本IFunctionNodeに対し動作します。
    /// （すでにメソッド化されてる部分については対象外）
    /// </summary>
    public class NodeVisitor
    {
        /// <summary>
        /// 結果を収めるリスト
        /// </summary>
        private List<INode> nodeList;
        public List<INode> NodeList {
            get { return this.nodeList; }
            set { this.nodeList = value; }
        }

        /// <summary>
        /// 構文木を分解します
        /// </summary>
        /// <param name="target"></param>
        public void eval(INode target) {
            if (target is InnerMethodNode) return;
            if (!(target is IFunctionNode)) return;
            this.nodeList.AddRange(((IFunctionNode)target).Args);
            foreach (INode node in ((IFunctionNode)target).Args)
            {
                NodeVisitor v = new NodeVisitor();
                v.NodeList = this.NodeList;
                v.eval(node);
            }
        }

    }
}
