﻿/**
Formula.Optimizer.NodeReplaceVisitor

Copyright (c) 2016 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Formula.Optimizer.InnerMethodOptimizer
{
    /// <summary>
    /// 対象となる構文木の中から該当するノードを探し出し、置換します。
    /// 検索はインスタンスが同一かどうかで判断します。
    /// インスタンスが持つ子ノードは検索の対象としません。
    /// </summary>
    public class NodeReplaceVisitor
    {
        /// <summary>
        /// 検索する構文木
        /// </summary>
        public INode TargetNode { get; set; }

        /// <summary>
        /// 検索します
        /// 検索はインスタンスが同一かどうかを基準として動作します
        /// </summary>
        /// <param name="find">検索対象</param>
        /// <param name="replace">置換対象</param>
        /// <returns></returns>
        public bool eval(INode find , INode replace)
        {
            bool ret = false;
            if (!(this.TargetNode is IFunctionNode)) return this.TargetNode == find;
            if (((IFunctionNode)this.TargetNode).Args.Count <= 0) return false;
            //foreach(INode node in ((IFunctionNode)find).Args)
            for(int i = 0; i < ((IFunctionNode)this.TargetNode).Args.Count; i++)
            {
                INode node = ((IFunctionNode)this.TargetNode).Args[i];
                if (node != find)
                {
                    NodeReplaceVisitor visitor = new NodeReplaceVisitor();
                    visitor.TargetNode = node;
                    ret = visitor.eval(find , replace);
                    if (ret) return ret;
                    continue;
                }
                else
                {
                    ((IFunctionNode)this.TargetNode).Args[i] = replace;
                    return true;
                }
            }
            return false;
        }
    }
}