﻿/**
Formula.Optimizer.NodeConnectVisitor

Copyright (c) 2016 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Formula.Node;

namespace Formula.Optimizer.InnerMethodOptimizer
{
    /// <summary>
    /// 構文木を直列化しListに詰めていきます。
    /// 動作としてはFormulaParserと逆に作用します。
    /// </summary>
    public class NodeConnectVisitor
    {
        public static void eval(List<INode> ret , INode target)
        {
            ret.Add(target);
            if (target is IValueNode) return;
            foreach( INode node in ((IFunctionNode)target).Args)
            {
                eval(ret, node);
            }
        }
    }
}
