﻿/**
Formula.Optimizer.NodeComparator

Copyright (c) 2016 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Formula.Optimizer.InnerMethodOptimizer
{
    /// <summary>
    /// ノードリストをソートするcomparatorです。
    /// </summary>
    public class NodeComparator : IComparer<List<INode>>
    {
        /// <summary>
        /// ノードのリスト同士を比較します。
        /// IValueNode：値を比較します。
        /// IFunctionNode：クラスの形式自体を比較します
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <returns></returns>
        public int Compare(List<INode> x, List<INode> y)
        {
            //要素の数が異なる
            if (x.Count != y.Count) return x.Count.CompareTo(y.Count);

            //要素を順番に比較していく
            for (int i = 0; i < x.Count; i++)
            {
                INode xn = x[i];
                INode yn = y[i];
                int t = 0;

                //クラスが異なる場合、同じでもvalue以外の場合は単純比較
                //両方valueの場合はvalueそのものを単純比較
                if (!xn.GetType().Equals(yn.GetType()) || !(xn is IValueNode))
                    t = xn.GetType().FullName.CompareTo(yn.GetType().FullName);
                else if (yn is BlankNode ) return -1;
                else t = ((IValueNode)xn).Value.ToString().CompareTo(((IValueNode)yn).Value.ToString());
                if (t == 0)
                    continue;

                return t;
            }
            return 0;
        }
    }
}
