﻿/**
Formula.Node.Impl.InnerMethodNode

Copyright (c) 2016 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Formula.Node.Impl
{
    /// <summary>
    /// オプティマイザの自動関数化で使用される内部関数です。
    /// Formula.Optimizer.InnerMethodOptimizer.InnerMethodOptimizerを参照してください。
    /// 内部で計算結果をキャッシュするため、実行単位で.reset()する必要があります。
    /// </summary>
    public class InnerMethodNode : AbstractMethodNode , IResetNode 
    {
        public override Type[] ArgCheckList { get { return new Type[] { }; } }

        public override Type ReturnNode { get{ return typeof(INode); } }

        public override string[] Signature { get { return new String[] { "DummyMethod"}; } }

        private INode result = null;

        /// <summary>
        /// 計算済みかどうかを返します
        /// </summary>
        /// <returns>true:計算済み false:未計算</returns>
        public bool IsAlreadyExec()
        {
            return this.result != null;
        }

        /// <summary>
        /// 結果をリセットします
        /// </summary>
        public void reset() {
            this.result = null;
        }

        /// <summary>
        /// 既に実行済みの場合、実行済み結果を返します
        /// 未実行の場合は計算結果を返します。
        /// </summary>
        /// <returns></returns>
        protected override INode execute()
        {
            if (this.result == null) this.result =  this.Args[0].eval();
            return this.result;
        }
    }
}
