﻿/**
Formula.Node.Impl.ErrorNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

namespace Formula.Node.Impl
{
    /// <summary>
    /// エラーノード
    /// </summary>
    public class ErrorNode : AbstractValueNode
    {
        public override decimal? getDecimal()
        {
            return null;
        }
        public override bool getBoolean()
        {
            return false;
        }
        public ErrorNode(string msg)
        {
            this.Value = msg;
        }
        public override string ToString()
        {
            return string.Format("{0}:[E:{1}-{2}]", this.nodeId, this.startPosition, this.endPosition);
        }
    }
}
