﻿/**
Formula.Node.Impl.WordNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;

namespace Formula.Node.Impl
{
    /// <summary>
    /// 文字列ノード
    /// 空文字を表現します。
    /// </summary>
    public class BlankNode : AbstractValueNode
    {
        public override string ToString()
        {
            return string.Format("{0}:[EMPTY:{1}-{2}] {3}", this.nodeId , this.startPosition, this.endPosition, this.Value );
        }
    }
}
