﻿/**
Formula.Node.IValueNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

namespace Formula.Node
{
    /// <summary>
    /// 値を表現するノード
    /// パース時に個々の要素が{Regex}に一致する場合、そのクラスが利用されます
    /// </summary>
    public interface IValueNode : INode
    {
        /// <summary>
        /// ノードが保持する値
        /// </summary>
        object Value { get; set; }
        /// <summary>
        /// シグネチャ（正規表現）
        /// 構文木作成時、この正規表現にマッチする場合、
        /// 文字列(WordNode)としてではなく、このクラスが利用されます。
        /// </summary>
        string Regex {  get; }
        /// <summary>
        /// ノードの値をdecimalで取得します
        /// </summary>
        /// <returns></returns>
        decimal? getDecimal();
        /// <summary>
        /// ノードの値をbooleanで取得します
        /// </summary>
        /// <returns></returns>
        bool getBoolean();
    }
}
