﻿/**
Formula.Node.INode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

namespace Formula.Node
{
    /// <summary>
    /// ノード
    /// 構文木の個々の要素を表現します。
    /// </summary>
    public interface INode
    {
        /// <summary>
        /// ノードを処理し、結果を取得します
        /// </summary>
        /// <returns>結果を保持するノード</returns>
        INode eval();
        /// <summary>
        /// ノードを特定するためのID
        /// </summary>
        int nodeId { get; }
        /// <summary>
        /// 式中の開始位置
        /// パース前の式において、このNodeが登場する開始位置を示します。
        /// </summary>
        int startPosition { get; set; }
        /// <summary>
        /// 式中の終了位置
        /// パース前の式において、このNodeが登場する終了位置を示します。
        /// </summary>
        int endPosition { get; set; }
        /// <summary>
        /// カレントノードの親ノード
        /// </summary>
        INode ParentNode { get; set; }
        /// <summary>
        /// カレントノードが所属する構文木のルートとなるノードを取得します
        /// </summary>
        /// <returns></returns>
        INode getRootNode();
    }
}
