﻿/**
Formula.Node.IMethodNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System.Collections.Generic;

namespace Formula.Node
{
    /// <summary>
    /// メソッドノード
    /// 関数を表現します。
    /// </summary>
    public interface IMethodNode : IFunctionNode
    {
        /// <summary>
        /// 引数リスト
        /// IFunctionNode.Argsの中身を単純に表現します。
        /// 例えば
        /// function(arg1,arg2,arg3)
        /// の場合、
        /// IMethodNode.FormatArgs[0]はarg1を取得します。
        /// </summary>
        List<INode> FormatArgs { get; }
    }
}
