﻿/**
Formula.Node.IFunctionNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;
using System.Collections.Generic;

namespace Formula.Node
{
    /// <summary>
    /// 関数を指すインターフェイス
    /// </summary>
    public interface IFunctionNode : INode
    {
        /// <summary>
        /// インターフェイスを示すシグネチャ
        /// パース時、要素がここに含まれる場合、
        /// このクラスが用いられます。
        /// IValueNode.Regexと違い、正規表現ではなく完全一致(大文字小文字区別なし)で評価されます
        /// </summary>
        string[] Signature { get; }
        /// <summary>
        /// 引数のリスト
        /// </summary>
        List<INode> Args { get; }

        /// <summary>
        /// 関数の引数タイプ
        /// FormulaCheckVisitorで使用されます。
        /// </summary>
        Type[] ArgCheckList { get; }

        /// <summary>
        /// 関数の戻り値
        /// </summary>
        Type ReturnNode { get; }
        /// <summary>
        /// 説明
        /// </summary>
        string Note { get; }
    }
}
