﻿/**
Formula.Node.ArrayVisitor

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System.Collections.Generic;

namespace Formula.Node
{
    /// <summary>
    /// 引数部分を示すノードツリーを整理するためのクラス
    /// </summary>
    public class ArrayVisitor
    {
        /// <summary>
        /// 処理対象ノード
        /// </summary>
        public INode target { get; set; }
        /// <summary>
        /// 引数として整理したノードを取得します
        /// </summary>
        /// <returns></returns>
        public List<INode> getArgs()
        {
            List<INode> ret = new List<INode>();
            if (target is IBracketNode)
            {
                target = ((IBracketNode)target).Args.Count > 0 ? ((IBracketNode)target).Args[0] : null ;
            }
            if (target is ISeparatorNode)
            {
                foreach (INode node in ((ISeparatorNode)target).Args)
                {
                    ArrayVisitor v = new ArrayVisitor();
                    v.target = node;
                    ret.AddRange(v.getArgs());
                }
            }
            else
            {
                ret.Add(this.target);
            }
            return ret;
        }
    }
}
