﻿/**
Formula.Node.AbstractValueNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;

namespace Formula.Node
{
    /// <summary>
    /// 値を表現するノード
    /// </summary>
    public abstract class AbstractValueNode : AbstractNode , IValueNode
    {
        /// <summary>
        /// ノードが保持する値
        /// </summary>
        public object value;
        public virtual object Value
        {
            get { return this.value; }
            set { this.value = value; }
        }
        /// <summary>
        /// シグネチャ(正規表現)
        /// 構文木作成時、この正規表現にマッチする場合、
        /// 文字列(WordNode)としてではなく、このクラスが利用されます。
        /// </summary>
        public virtual string Regex { get; }
        /// <summary>
        /// ノードの演算結果を返します
        /// </summary>
        /// <returns></returns>
        public override INode eval()
        {
            return this;
        }
        /// <summary>
        /// ノードが保持する値をdecimalで取得します
        /// </summary>
        /// <returns></returns>
        public virtual decimal? getDecimal()
        {
            decimal ret;
            if (this.value == null) return null;
            else if (decimal.TryParse(this.value.ToString(), out ret))
                return ret;
            return null;
        }
        /// <summary>
        /// ノードが保持する値をbooleanで取得します
        /// </summary>
        /// <returns></returns>
        public virtual bool getBoolean()
        {
            if (this.value == null) return false;
            else if (this.value is Boolean) return (bool)this.value;
            else if (string.IsNullOrWhiteSpace(this.value.ToString())) return false;
            else if (this.value is decimal) return ((decimal)this.value) == 0 ? false : true;
            bool ret;
            if (Boolean.TryParse(this.value.ToString(), out ret))
                return ret;
            
            return this.value.ToString() == "0" ? false : true ;
        }



    }
}
