﻿/**
Formula.Node.AbstractOperatorNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;

namespace Formula.Node
{
    /// <summary>
    /// 演算子の実装
    /// </summary>
    public abstract class AbstractOperatorNode : AbstractFunctionNode, IOperatorNode
    {
        /// <summary>
        /// カレントノードを起点として置換すべきノードの親部分を取得します。
        /// ※InnerMethodOptimizerで使用されるInnerMethodNodeは親を持たないため、Optimizer使用後は正常に動作しません。
        /// </summary>
        /// <returns></returns>
        public IOperatorNode getPriorityParentNode()
        {
            INode ret = this;
            if (this.ParentNode == null) return this;
            //if (this.ParentNode is SeparatorNode) return (IOperatorNode)ret;
            if (!(((IOperatorNode)ret).ParentNode is IOperatorNode)) return (IOperatorNode)ret;
            if (((IOperatorNode)this).priority > ((IOperatorNode)((IOperatorNode)ret).ParentNode).priority) return this;

            return ((IOperatorNode)this.ParentNode).getPriorityParentNode();
        }


        /// <summary>
        /// カレントノードの左ノードを取得します
        /// </summary>
        /// <returns></returns>
        public INode getLeftNode()
        {
            if (this.Args.Count > 0) return this.Args[0];
            return null;
        }
        /// <summary>
        /// カレントノードの右ノードを取得します
        /// </summary>
        /// <returns></returns>
        public INode getRightNode()
        {
            if (this.Args.Count > 1) return this.Args[1];
            return null;
        }
        /// <summary>
        /// カレントノードに左ノードをセットします
        /// </summary>
        /// <param name="node"></param>
        public void setLeftNode(INode node)
        {
            if (this.Args.Count <= 0) this.Args.Add(node);
            else this.Args[0] = node;
        }
        /// <summary>
        /// カレントノードに右ノードをセットします
        /// </summary>
        /// <param name="node"></param>
        public void setRightNode(INode node)
        {
            if (this.Args.Count <= 0)
                this.Args.Add(null);

            if (this.Args.Count <= 1)
                this.Args.Add(node);
            else this.Args[1] = node;
        }

        /// <summary>
        /// カレントノードが指し示すシグネチャ
        /// </summary>
        public override string[] Signature
        {
            get { throw new NotImplementedException(); }
        }

        /// <summary>
        /// 演算子の優先度
        /// </summary>
        public abstract int priority { get; }
        /// <summary>
        /// 左辺ノードが省略可能な場合にTrue
        /// </summary>
        public abstract bool IsPermitLeftNodeBlank { get; }

        public override string ToString()
        {
            return string.Format("{0}:[{1}:{2}-{3}]", this.nodeId, string.Join("", this.Signature) + (this.IsPermitLeftNodeBlank ? "(sign)" : ""), this.startPosition, this.endPosition);
        }
    }
}
