﻿/**
Formula.Node.AbstractNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

namespace Formula.Node
{
    /// <summary>
    /// ノードの実装
    /// </summary>
    public abstract class AbstractNode : INode
    {
        /// <summary>
        /// 式中の開始位置
        /// パース前の式において、このNodeが登場する開始位置を示します。
        /// </summary>
        public int startPosition { get; set; }
        /// <summary>
        /// 式中の終了位置
        /// パース前の式において、このNodeが登場する終了位置を示します。
        /// </summary>
        public int endPosition { get; set; }
        /// <summary>
        /// ノードを特定するためのID
        /// ノードを一意に特定するためのIDです。
        /// </summary>
        public int nodeId { get; set; }
        /// <summary>
        /// ノードがぶら下がる親ノード
        /// </summary>
        public INode ParentNode{get;set;}
        /// <summary>
        /// ノードを処理し、結果を取得する
        /// </summary>
        /// <returns>処理結果を保持するノード</returns>
        public abstract INode eval() ;
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public AbstractNode()
        {
            this.nodeId = ObjectIdUtility.getInstance().NextVal();
        }
        /// <summary>
        /// ノードが所属する構文木のルートを取得します
        /// ※InnerMethodOptimizerで使用されるInnerMethodNodeは親を持たないため、Optimizerを使用した後はこのメソッドは正常に動作しません。
        /// </summary>
        /// <returns></returns>
        public INode getRootNode()
        {
            if (this.ParentNode == null) return this;
            return this.ParentNode;
        }


    }
}
