﻿


using Formula.Node.Impl;
/**
Formula.Node.AbstractMethodNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;
using System.Collections.Generic;

namespace Formula.Node
{
    /// <summary>
    /// メソッドの実装
    /// </summary>
    public abstract class AbstractMethodNode : AbstractFunctionNode, IMethodNode
    {
        /// <summary>
        /// 引数のリスト
        /// </summary>
        public List<INode> FormatArgs
        {
            get {
                //if (this.formatArgs != null) return this.formatArgs;
                //this.formatArgs = new List<INode>();
                List<INode> formatArgs = new List<INode>();
                foreach (INode elem in this.Args)
                {
                    ArrayVisitor visitor = new ArrayVisitor();
                    visitor.target = elem;
                    formatArgs.AddRange(visitor.getArgs());
                }
                return formatArgs;
            }
        }

        /// <summary>
        /// 計算済みの引数を取得します。
        /// 引数のnullチェックは呼び出しがわで実装してください。
        /// </summary>
        /// <param name="argNumber">引数の番号。0始まりで指定します(第一引数を取得する場合0)</param>
        /// <param name="isCheck">エラーかどうかをチェックする true:チェックする false:チェックしない</param>
        /// <returns></returns>
        protected INode getArgsAlready(int argNumber , Boolean isCheck = true)
        {
            INode ret = null;
            if (this.FormatArgs.Count <= argNumber)
                throw new ArgumentException("該当する引数が定義されていません。");
            if (this.FormatArgs[argNumber] == null) return null;
            ret = this.FormatArgs[argNumber].eval();
            if (isCheck && ret is ErrorNode)
                throw new ArgumentException("引数の結果がエラーです。 / "
                     + ((ErrorNode)ret).value == null ? "" : ((ErrorNode)ret).value.ToString());
            return ret;
        }
    }
}
