﻿/**
Formula.Node.AbstractFunctionNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node.Impl;
using System;
using System.Collections.Generic;

namespace Formula.Node
{
    /// <summary>
    /// 関数の実装
    /// </summary>
    public abstract class AbstractFunctionNode : AbstractNode
    {
        /// <summary>
        /// 関数のシグネチャ
        /// </summary>
        public abstract string[] Signature { get; }

        /// <summary>
        /// 関数の引数タイプ
        /// </summary>
        public abstract Type[] ArgCheckList { get; }

        /// <summary>
        /// 関数の戻り値タイプ
        /// </summary>
        public abstract Type ReturnNode { get; }

        /// <summary>
        /// 説明
        /// </summary>
        public virtual string Note { get { return "- 説明はありません -"; } }

        /// <summary>
        /// 引数のリスト
        /// </summary>
        public List<INode> Args { get; set; }
      
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public AbstractFunctionNode() 
        {
            this.Args = new List<INode>();
        }

        /// <summary>
        /// 処理の本体
        /// </summary>
        /// <returns>結果を保持するノード</returns>
        protected abstract INode execute();
        /// <summary>
        /// 関数を実行し、結果を返します
        /// </summary>
        /// <returns>結果を保持するノード</returns>
        public override INode eval()
        {
            INode ret = null;
            try
            {
                ret = this.execute();
            }
            catch (System.Exception e)
            {
                ret = new ErrorNode(e.Message);
            }
            return ret;
        }
        
        public override string ToString()
        {
            return string.Format("{0}:[{1}:{2}-{3}]", this.nodeId, string.Join("", this.Signature), this.startPosition, this.endPosition );
        }
    }
}
