/**
 * Moxkiriya standalone Wiki.
 * TOC(Table Of Contents) Builder.
 * 
 * @author Ryuhei Terada
 * See the '<a href="{@docRoot}/copyright.html">Copyright</a>'
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;


import java.util.ArrayList;
import java.util.ResourceBundle;

/**
 * WikiTOCBuilder
 *
 */
public class WikiTOCBuilder {
	private static final String MACRO_INSERTTOC = "{{#TOC}}";
	
	/**
	 * Headline(見出し)リストのノード
	 */
	class HeadlineNode {
		/** Headline(見出し)名 */
		String id_;

		/** Headlineレベル */
		int    headLineLevel_;

		/**
		 * Constractor
		 * @param id
		 * @param level
		 */
		HeadlineNode(String id, int level) {
			id_            = id;
			headLineLevel_ = level;
		}
	}

	/** page内の見出しのリスト */
	private ArrayList<HeadlineNode> headlineList_ = new ArrayList<HeadlineNode>();

	/**
	 * headlineListにエントリーを追加する。
	 * @param id
	 * @param level
	 */
	public void add(String id, int level) {
 		headlineList_.add(new HeadlineNode(id, level));
	}

	/**
	 * TOC(目次)を構築する
	 * @param line
	 * @return　構築した目次
	 */
	public String buildTOC(String line) {
		StringBuffer   buf    = new StringBuffer("");
		ResourceBundle bundle = ResourceBundle.getBundle("com.wiki.standalone.moxkiriya.resources.moxkiriya");
		
		if( (line != null)
		 && (line.startsWith(MACRO_INSERTTOC) == true)) {
			if(false) {
				/*
				 * クリックに反応しないので、[show]/[hide]一時無効
				 */
				buf.append(	  "<div class=\"tocbox\">\n"
							+ "<input type=\"checkbox\" id=\"toc\">\n"
							+ "<label for=\"toc\">"
								+ bundle.getString("key.Contents")
							+ "</label>\n"
							+ "<div class=\"hidden_show\">\n");
				buf.append(buildTOCList());
				buf.append(   "</div>\n"
							+ "</div>");
			}
			else {
				buf.append("<div class=\"tocbox\">\n"
							+ "<div class=\"title\">"
							+ bundle.getString("key.Contents")
							+ "</div>\n");
				buf.append(buildTOCList());
				buf.append(	  "</div>\n");
			}
		}

		return buf.toString();
	}
	
	/**
	 * TOC(目次)リストを構築する。
	 * @return 構築した目次リスト
	 */
	private String buildTOCList() {
		int          depth = 0;
		StringBuffer buf   = new StringBuffer("<ul>\n");

		for(HeadlineNode node: headlineList_) {
			if(node.headLineLevel_ - 2 < depth) {
				while(node.headLineLevel_ - 2 < depth) {
					depth--;
					buf.append("</ul>\n");
				}
			}
			else if(node.headLineLevel_ - 2 > depth) {
				while(node.headLineLevel_ - 2 > depth) {
					depth++;
					buf.append("<ul>\n");
				}
				
			}

			buf.append(	  "<li><a href=\"#"
					+ node.id_
					+ "\")>"
					+ node.id_
					+ "</a></li>\n");
		}
		buf.append("</ul>\n");
		
		return buf.toString();
	}
}
