/**
 * Moxkiriya standalone Wiki.
 * ConfigSettingsDialogController.
 * 
 * @author Ryuhei Terada
 * See the '<a href="{@docRoot}/copyright.html">Copyright</a>'
 */package com.wiki.standalone.moxkiriya.dialog;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.ResourceBundle;

import com.wiki.standalone.moxkiriya.SettingManager;
import com.wiki.standalone.moxkiriya.WikiEngine;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;

/**
 * ConfigSettingダイアログコントローラ
 */
public class ConfigSettingsDialogController extends DialogControllerBase {
	@FXML   private TextField textFieldPartyName;
	@FXML   private CheckBox  checkBoxDefaultParty;
	@FXML	private TextField textFieldApproot;
	@FXML	private Button    buttonChooseDirectory;
	@FXML   private CheckBox  checkBoxClusterSetting;
	@FXML   private TextField textFieldDBServerURL;
	@FXML	private TextField textFieldPortNumber;
	@FXML   private TextField textFieldJDBCDriver;
	@FXML	private Button    buttonOK;

	/** parent window */
	private Window parentWindow_;

	/** party name specified parent window. */
	private String partyName_;
	
	/** setting map */
	private Hashtable<String, String> settingsTable_;

	/**
	 * 親Windowを設定する。
	 * @param window
	 */
	public void setWindow(Window window) {
		parentWindow_ = window;
	}

	/**
	 * Party name setter.
	 * @param partyName
	 */
	public void setPartyName(String partyName) {
		partyName_ = partyName;

		if( (partyName_ != null)
		 && (partyName_.isEmpty() != true)) {
			SettingManager settingMgr = SettingManager.getInstance();
			String         path       = settingMgr.get(SettingManager.SETTINGSKEY_MOXKIRIYA_USER_DIR);
			try {
				settingsTable_ = settingMgr.loadConfigSettings(path, partyName_);
				textFieldPartyName.setText(partyName_);
				if( (partyName_ != null)
				 && (partyName_.isEmpty() != true)) {
					textFieldPartyName.setEditable(false);
					textFieldPartyName.setDisable(true);
				}
				Hashtable<String, Boolean> partyTable = settingMgr.getPartyTable();
				if(partyTable.get(partyName_) == true) {
					checkBoxDefaultParty.setSelected(true);
				}
	
				String text = settingsTable_.get(SettingManager.SETINGKEY_MOXKIRIYAROOT);

				textFieldApproot.setText(text == null ? "" : text);
				String clusterSetting = settingsTable_.get(SettingManager.SETINGKEY_CLUSTER);
				if( (clusterSetting != null)
				 && (clusterSetting.equals("true"))) {
					checkBoxClusterSetting.setSelected(true);
					
					text = settingsTable_.get(SettingManager.SETINGKEY_DBSERVER_URL);
					textFieldDBServerURL.setText(text == null ? "" : text);
					
					text = settingsTable_.get(SettingManager.SETINGKEY_DBSERVER_PORT);
					textFieldPortNumber.setText(text == null ? "" : text);

					text = settingsTable_.get(SettingManager.SETINGKEY_JDBC_DRIVER);
					textFieldJDBCDriver.setText(text == null ? "" : text);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void initialize(URL url, ResourceBundle resource) {
		super.initialize(url, resource);
		buttonOK.setDisable(true);
		
		ChangeListener<String> textFieldchangeListener = new ChangeListener<String>() {
			@Override
			public void changed(ObservableValue<? extends String> arg0, String oldValue, String newValue) {
				buttonOK.setDisable(canEnableOKButton());
			}
		};
		textFieldPartyName.textProperty().addListener(textFieldchangeListener);
		textFieldApproot.textProperty().addListener(textFieldchangeListener);
		textFieldDBServerURL.textProperty().addListener(textFieldchangeListener);
		textFieldPortNumber.textProperty().addListener(textFieldchangeListener);
		textFieldJDBCDriver.textProperty().addListener(textFieldchangeListener);

		checkBoxClusterSetting.selectedProperty().addListener(new ChangeListener<Boolean>() {
			@Override
			public void changed(ObservableValue<? extends Boolean> value, Boolean oldValue, Boolean newValue) {
				if(newValue == true) {
					textFieldDBServerURL.setDisable(false);
					textFieldPortNumber.setDisable(false);
					textFieldJDBCDriver.setDisable(false);
				}
				else {
					textFieldDBServerURL.setDisable(true);
					textFieldPortNumber.setDisable(true);
					textFieldJDBCDriver.setDisable(true);
				}
				buttonOK.setDisable(canEnableOKButton());
			}			
		});

	}
	
	@FXML
	void onActionButtonChooseDirectory(ActionEvent event) {
		DirectoryChooser directoryChooser = new DirectoryChooser();
		String home = SettingManager.getInstance().get(SettingManager.SETTINGSKEY_USER_HOME);

		directoryChooser.setInitialDirectory(new File(home));
		File choicedDirectory = directoryChooser.showDialog(parentWindow_);
		
		if ((choicedDirectory.exists() == true)
		 && (choicedDirectory.isDirectory() == true)) {
			textFieldApproot.setText(choicedDirectory.getPath());
			buttonOK.setDisable(false);
		}
	}

	@FXML
	void onActionButtonOK(ActionEvent event) {
		try {
			if(partyName_ == null) {
				SettingManager settingMgr    = SettingManager.getInstance();
				String         selectedParty = textFieldPartyName.getText();
				String         moxkiriyaRoot = textFieldApproot.getText();
	
				settingMgr.putParty(selectedParty, checkBoxDefaultParty.isSelected());
				settingMgr.setSelectedParty(selectedParty);
				
				settingMgr.put(SettingManager.SETINGKEY_MOXKIRIYAROOT, moxkiriyaRoot);
				settingMgr.put(SettingManager.SETTINGSKEY_WIKIROOT,
						moxkiriyaRoot
						+ "/"
						+ WikiEngine.WIKIROOT_DIRECTORY);
		
				File wikiroot = new File(settingMgr.get(SettingManager.SETTINGSKEY_WIKIROOT));
				if(wikiroot.exists() != true) {
					wikiroot.mkdirs();
				}
				if(checkBoxClusterSetting.selectedProperty().get() == true) {
					settingMgr.put(SettingManager.SETINGKEY_CLUSTER, "true");
					settingMgr.put(SettingManager.SETINGKEY_DBSERVER_URL, textFieldDBServerURL.getText());
					settingMgr.put(SettingManager.SETINGKEY_DBSERVER_PORT, textFieldPortNumber.getText());
					settingMgr.put(SettingManager.SETINGKEY_JDBC_DRIVER, textFieldJDBCDriver.getText());
				}
				else {
					settingMgr.put(SettingManager.SETINGKEY_CLUSTER, "false");
					settingMgr.put(SettingManager.SETINGKEY_DBSERVER_URL, "");
					settingMgr.put(SettingManager.SETINGKEY_DBSERVER_PORT, "");
					settingMgr.put(SettingManager.SETINGKEY_JDBC_DRIVER, "");
				}
				settingMgr.save();
				settingMgr.putParty(selectedParty, true);	
			}
			((Node)event.getSource()).getScene().getWindow().hide();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Judge whether OK button can enable or not.
	 * @return
	 */
	private boolean canEnableOKButton() {
		boolean isDisable = textFieldPartyName.getText().isEmpty();
		
		if(isDisable == false) {
			String text = textFieldApproot.getText();
			isDisable = (text == null) || (text.isEmpty() == true);
		}

		if(checkBoxClusterSetting.selectedProperty().getValue() == true) {
			if(isDisable == false) {
				String text = textFieldDBServerURL.getText();
				isDisable = (text == null) || (text.isEmpty() == true);
			}
			
			if(isDisable == false) {
				String text = textFieldPortNumber.getText();
				isDisable = (text == null) || (text.isEmpty() == true);
			}
			
			if(isDisable == false) {
				String text = textFieldJDBCDriver.getText();
				isDisable = (text == null) || (text.isEmpty() == true);
			}
		}
		
		return isDisable;
	}

	/**
	 * Settings table getter.
	 * @return Hashtable<String, String>
	 */
	public Hashtable<String, String> getSettingsTable() {
		Hashtable<String, String> settingsTable = new Hashtable<String, String>();		
		String                    moxkiriyaRoot = textFieldApproot.getText();

		settingsTable.put(SettingManager.SETINGKEY_MOXKIRIYAROOT, moxkiriyaRoot);
		settingsTable.put(SettingManager.SETTINGSKEY_WIKIROOT,
				moxkiriyaRoot
				+ "/"
				+ WikiEngine.WIKIROOT_DIRECTORY);

		if(checkBoxClusterSetting.selectedProperty().get() == true) {
			settingsTable.put(SettingManager.SETINGKEY_CLUSTER, "true");
			settingsTable.put(SettingManager.SETINGKEY_DBSERVER_URL, textFieldDBServerURL.getText());
			settingsTable.put(SettingManager.SETINGKEY_DBSERVER_PORT, textFieldPortNumber.getText());
			settingsTable.put(SettingManager.SETINGKEY_JDBC_DRIVER, textFieldJDBCDriver.getText());
		}
		else {
			settingsTable.put(SettingManager.SETINGKEY_CLUSTER, "false");
			settingsTable.put(SettingManager.SETINGKEY_DBSERVER_URL, "");
			settingsTable.put(SettingManager.SETINGKEY_DBSERVER_PORT, "");
			settingsTable.put(SettingManager.SETINGKEY_JDBC_DRIVER, "");
		}
		
		return settingsTable;
	}

	/**
	 * Default party checkbox value getter.
	 * @return boolean
	 */
	public boolean getDefaultPartyCheckValue() {
		return checkBoxDefaultParty.isSelected();
	}

	/**
	 * Party name getter.
	 * @return String
	 */
	public String getPartyName() {
		return textFieldPartyName.getText();
	}
}
