// -*- C++ -*-
/*!
 * @file  OutPortConsumer.h
 * @brief OutPortConsumer class
 * @date  $Date: 2007-12-31 03:08:05 $
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2006-2009
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id: OutPortConsumer.h 1756 2010-01-22 08:43:33Z fsi-katami $
 *
 */

#ifndef RTC_OUTPORTCONSUMER_H
#define RTC_OUTPORTCONSUMER_H

#include <coil/Factory.h>
#include <rtm/DataPortStatus.h>
#include <rtm/CdrBufferBase.h>

#ifndef ORB_IS_RTORB
namespace SDOPackage
{
  class NVList;
};
#endif

namespace coil
{
  class Properties;
};

namespace RTC
{
  class ConnectorListeners;
  class ConnectorInfo;

  /*!
   * @if jp
   *
   * @class OutPortConsumer
   *
   * @brief OutPortConsumer ݥ饹
   *
   * ϥݡȥ󥷥塼ޤΤݥ󥿡ե饹
   * ƶݥ饹ϡʲν貾۴ؿμ󶡤ʤФʤʤ
   * - pull(): ǡ
   * - subscribeInterface(): ǡΤؤϿ
   * - unsubscribeInterface(): ǡΤϿ
   *
   * @since 0.4.0
   *
   * @else
   * @class OutPortConsumer
   *
   * @brief OutPortConsumer abstract class
   *
   * This is the abstract interface class for the output port Consumer.
   * Concrete classes must implement the following pure virtual functions.
   * - pull(): Receive data
   * - subscribeInterface(): Subscribe to the data receive notification
   * - unsubscribeInterface(): Unsubscribe the data receive notification
   *
   * @since 0.4.0
   *
   * @endif
   */
  class OutPortConsumer
    : public DataPortStatus
  {
  public:
    DATAPORTSTATUS_ENUM
    
    /*!
     * @if jp
     *
     * @brief ǥȥ饯
     *
     * ǥȥ饯
     *
     * @else
     * @brief Destructor
     *
     * Destructor
     *
     * @endif
     */
    virtual ~OutPortConsumer(void){};

    /*!
     * @if jp
     * @brief 
     *
     * OutPortConsumerγƼԤ饹ǤϡͿ줿
     * PropertiesɬפʾƳƼԤ init() 
     * ϡOutPortProviderľ太ӡ³ˤ줾ƤФ
     * ǽ롣äơδؿʣƤФ뤳ȤꤷƵ
     * Ҥ٤Ǥ롣
     * 
     * @param prop 
     *
     * @else
     *
     * @brief Initializing configuration
     *
     * This operation would be called to configure in initialization.
     * In the concrete class, configuration should be performed
     * getting appropriate information from the given Properties data.
     * This function might be called right after instantiation and
     * connection sequence respectivly.  Therefore, this function
     * should be implemented assuming multiple call.
     *
     * @param prop Configuration information
     *
     * @endif
     */
    virtual void init(coil::Properties& prop) = 0;

    /*!
     * @if jp
     * @brief Хåե򥻥åȤ
     *
     * OutPortConsumerǡФХåե򥻥åȤ롣
     * Ǥ˥åȤ줿Хåե硢ΥХåեؤ
     * ݥ󥿤Фƾ񤭤롣
     * OutPortProviderϥХåեνͭꤷƤʤΤǡ
     * Хåեκϥ桼ǤǹԤʤФʤʤ
     *
     * @param buffer OutPortProviderǡФХåեؤΥݥ
     *
     * @else
     * @brief Setting outside buffer's pointer
     *
     * A pointer to a buffer from which OutPortProvider retrieve data.
     * If already buffer is set, previous buffer's pointer will be
     * overwritten by the given pointer to a buffer.  Since
     * OutPortProvider does not assume ownership of the buffer
     * pointer, destructor of the buffer should be done by user.
     * 
     * @param buffer A pointer to a data buffer to be used by OutPortProvider
     *
     * @endif
     */
    virtual void setBuffer(CdrBufferBase* buffer) = 0;
    /*!
     * @if jp
     * @brief ꥹʤꤹ롣
     * @else
     * @brief Set the listener. 
     * @endif
     */
    virtual void setListener(ConnectorInfo& info,
                             ConnectorListeners* listeners) = 0;

    /*!
     * @if jp
     *
     * @brief ǡ
     *
     * ǡ¹Ԥ뤿ν貾۴ؿ
     * ݥ饹Ǥϡ줾ˡǥ⡼ȤOutPortǡ
     * å롣
     * ˴ؤ֤˱ưʲ֤ͤ
     *
     * @param data ǡ
     * @return PORT_OK         ｪλ
     *         BUFFER_TIMEOUT  ॢȤ
     *         RECV_EMPTY      ΥХåեǤ롣
     *         CONNECTION_LOST ³Ǥ줿
     *         PORT_ERROR      顼
     *         UNKNOWN_ERROR   褢ꤨʤ顼
     *
     * @else
     *
     * @brief Receive data
     *
     * Pure virtual function to receive data.
     *
     * @endif
     */
    virtual ReturnCode get(cdrMemoryStream& data) = 0;

    /*!
     * @if jp
     *
     * @brief ǡΤؤϿ
     *
     * ꤵ줿ץѥƥ˴ŤơǡΤϿ뤿
     * 貾۴ؿ
     *
     * @param properties Ͽѥץѥƥ
     *
     * @return Ͽ(Ͽ:trueϿ:false)
     *
     * @else
     *
     * @brief Subscribe the data receive notification
     *
     * Pure virtual function to subscribe the data receive notification
     * based on specified property information.
     *
     * @param properties Properties for subscription
     *
     * @return Subscription result (Successful:true, Failed:false)
     *
     * @endif
     */
    virtual bool subscribeInterface(const SDOPackage::NVList& properties) = 0;
    
    /*!
     * @if jp
     *
     * @brief ǡΤϿ
     *
     * ǡΤϿ뤿ν貾۴ؿ
     *
     * @param properties Ͽѥץѥƥ
     *
     * @return Ͽ(Ͽ:trueϿ:false)
     *
     * @else
     *
     * @brief Unsubscribe the data receive notification
     *
     * Pure virtual function to unsubscribe the data receive notification.
     *
     * @param properties Properties for unsubscription
     *
     * @return Unsubscription result (Successful:true, Failed:false)
     *
     * @endif
     */
    virtual void unsubscribeInterface(const SDOPackage::NVList& properties) = 0;

  protected:
    /*!
     * @if jp
     * @brief ȥ꡼
     * @else
     * @brief Logger stream
     * @endif
     */
    mutable Logger rtclog;

    /*!
     * @if jp
     * @brief Interface³Functor
     * @else
     * @brief Functor to subscribe the interface
     * @endif
     */
    struct subscribe
    {
      subscribe(const SDOPackage::NVList& prop) : m_prop(prop) {}
      void operator()(OutPortConsumer* consumer)
      {
        consumer->subscribeInterface(m_prop);
      }
      const SDOPackage::NVList& m_prop;
    };
    
    /*!
     * @if jp
     * @brief Interface³Functor
     * @else
     * @brief Functor to unsubscribe the interface
     * @endif
     */
    struct unsubscribe
    {
      unsubscribe(const SDOPackage::NVList& prop) : m_prop(prop) {}
      void operator()(OutPortConsumer* consumer)
      {
        consumer->unsubscribeInterface(m_prop);
      }
      const SDOPackage::NVList& m_prop;
    };
  };

  typedef ::coil::GlobalFactory<OutPortConsumer> OutPortConsumerFactory;

};     // namespace RTC
#endif // OutPortConsumer_h

