// -*- C++ -*-
/*!
 * @file  MutexPosix.h
 * @brief RT-Middleware Service interface
 * @date  $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2008
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef COIL_UUID_H
#define COIL_UUID_H

#include <rpc.h>

namespace coil
{
#ifdef uuid_t
#undef uuid_t
  typedef ::GUID uuid_t;
#endif
  //------------------------------------------------------------
  // UUID class
  //------------------------------------------------------------
  /*!
   * @if jp
   * @class UUID NX
   * @brief UUID ̒lێNX
   * @else
   * @class UUID class
   * @brief UUID value class
   * @endif
   */
  class UUID
  {
  public:
    /*!
     * @if jp
     * @brief UUIDNX RXgN^
     *
     * @else
     * @brief UUID class constructor
     *
     * @endif
     */
    UUID();

    /*!
     * @if jp
     * @brief UUIDNX RXgN^
     *
     * @else
     * @brief UUID class constructor
     *
     * @endif
     */
    UUID(const uuid_t& uuid);

    /*!
     * @if jp
     * @brief UUIDNX fXgN^
     *
     * @else
     * @brief UUID class destructor
     *
     * @endif
     */
    ~UUID();

    /*!
     * @if jp
     * @brief UUIDl𕶎ɕϊ
     *
     * @else
     * @brief Converting from UUID value to string
     *
     * @endif
     */
    const char* to_string();

  private:
    uuid_t m_uuid;
    char* m_uuidstr;
  }; // class UUID


  //------------------------------------------------------------
  // UUID_Generator class
  //------------------------------------------------------------
  /*!
   * @if jp
   * @class UUID NX
   * @brief UUID l𐶐NX
   * @else
   * @class UUID generator class
   * @brief Generate UUID value
   * @endif
   */
  class UUID_Generator
  {
  public:
    /*!
     * @if jp
     * @brief UUIDNX RXgN^
     *
     * @else
     * @brief UUID class constructor
     *
     * @endif
     */
    UUID_Generator();

    /*!
     * @if jp
     * @brief UUIDNX fXgN^
     *
     * @else
     * @brief UUID class destructor
     *
     * @endif
     */
    ~UUID_Generator();

    /*!
     * @if jp
     * @brief 
     *
     * @else
     * @brief Initialization
     *
     * @endif
     */
    void init();

    /*!
     * @if jp
     * @brief UUID𐶐
     *
     * @param n gp
     * @param h gp
     * @return ꂽUUIDl. Ăяo delete KvB
     *
     * @else
     * @brief Generate UUID value
     *
     * @param n unused
     * @param h unused
     * @return new UUID value. This value should be deleted by user.
     *
     * @endif
     */
    coil::UUID* generateUUID(int n, int h);
  }; // class UUID_Generator
}; // coil

#endif // COIL_UUID_H
