// -*- C++ -*-
/*!
 * @file Task.cpp
 * @brief Task class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2008
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#include <coil/Task.h>
#ifdef __T_KERNEL__
#include <btron/proctask.h>
#endif
#ifdef DEBUG
#include <util/tmonitor.h>
#endif

namespace coil
{

  Task::Task()
    : m_count(0)
  {
    ::pthread_attr_init(&m_attr);
  }

  Task::~Task()
  {
    m_count = 0;
  }

  int Task::open(void* args)
  {
    return 0;
  }

  int Task::close(unsigned long flags)
  {
    return 0;
  }

  int Task::svc()
  {
    return 0;
  }

  void Task::activate()
  {
    if (m_count == 0)
      {
#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
        printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
        ::pthread_create(&m_thread,
                         &m_attr,
                         (void(*)(void*))Task::svc_run,
                         this);
#ifdef DEBUG_T_KERNEL
        printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
#else
        ::pthread_create(&m_thread,
                         &m_attr,
                         (void* (*)(void*))Task::svc_run,
                         this);
#endif
        ++m_count;
      };
  }

  int Task::wait(void)
  {
    if (m_count > 0)
      {
        void* retval;
        ::pthread_join(m_thread, &retval);
      }
    return 0;
  }

  int Task::suspend(void)
  {
    return 0;
  }

  int Task::resume(void)
  {
    return 0;
  }

  void Task::reset()
  {
    m_count = 0;
  }
  void Task::finalize()
  {
    reset();
  }
  void* Task::svc_run(void* args)
  {
    Task* t = (coil::Task*)args;
    int status;
    status = t->svc();
    t->finalize();
#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
    b_ext_tsk();
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
#else
    return 0;
#endif
  }
};


