package com.rogerfgm;

import java.util.ArrayList;
import java.util.List;

public class Sasite {
	/**
	 * łɕ]lĂ
	 * 
	 * @param k
	 * @return
	 * @throws Exception
	 */
	public static final List<Kyokumen> createSasiteList(Kyokumen k, boolean b)
			throws Exception {

		List<Kyokumen> list = new ArrayList<Kyokumen>();
		if(k.isOu_b() || k.isOu_w()){
			return list;
		}
		if(b){
			processFu_b(k.b_fu.ue, 0, k, list);
			processFu_b(k.b_fu.mid, 1, k, list);
			processFu_b(k.b_fu.sita, 2, k, list);
	
			processTo_b(k.b_to.ue, 0, k, list);
			processTo_b(k.b_to.mid, 1, k, list);
			processTo_b(k.b_to.sita, 2, k, list);
			
			processKyo_b(k.b_kyo.ue, 0, k, list);
			processKyo_b(k.b_kyo.mid, 1, k, list);
			processKyo_b(k.b_kyo.sita, 2, k, list);
			
			processNarikyo_b(k.b_narikyo.ue, 0, k, list);
			processNarikyo_b(k.b_narikyo.mid, 1, k, list);
			processNarikyo_b(k.b_narikyo.sita, 2, k, list);
			
			processKei_b(k.b_kei.ue, 0, k, list);
			processKei_b(k.b_kei.mid, 1, k, list);
			processKei_b(k.b_kei.sita, 2, k, list);
			processNarikei_b(k.b_narikei.ue, 0, k, list);
			processNarikei_b(k.b_narikei.mid, 1, k, list);
			processNarikei_b(k.b_narikei.sita, 2, k, list);
			processGin_b(k.b_gin.ue, 0, k, list);
			processGin_b(k.b_gin.mid, 1, k, list);
			processGin_b(k.b_gin.sita, 2, k, list);
			processNarigin_b(k.b_narigin.ue, 0, k, list);
			processNarigin_b(k.b_narigin.mid, 1, k, list);
			processNarigin_b(k.b_narigin.sita, 2, k, list);
	
			processKin_b(k.b_kin.ue, 0, k, list);
			processKin_b(k.b_kin.mid, 1, k, list);
			processKin_b(k.b_kin.sita, 2, k, list);
			processKaku_b(k.b_kaku.ue, 0, k, list);
			processKaku_b(k.b_kaku.mid, 1, k, list);
			processKaku_b(k.b_kaku.sita, 2, k, list);
			processUma_b(k.b_uma.ue, 0, k, list);
			processUma_b(k.b_uma.mid, 1, k, list);
			processUma_b(k.b_uma.sita, 2, k, list);
			processHisha_b(k.b_hisha.ue, 0, k, list);
			processHisha_b(k.b_hisha.mid, 1, k, list);
			processHisha_b(k.b_hisha.sita, 2, k, list);
			processRyu_b(k.b_ryu.ue, 0, k, list);
			processRyu_b(k.b_ryu.mid, 1, k, list);
			processRyu_b(k.b_ryu.sita, 2, k, list);
	
			processOu_b(k.b_ou.ue, 0, k, list);
			processOu_b(k.b_ou.mid, 1, k, list);
			processOu_b(k.b_ou.sita, 2, k, list);
	
			processUtsu_b(k, list);
		}
		else{
			processFu_w(k.w_fu.ue, 0, k, list);
			processFu_w(k.w_fu.mid, 1, k, list);
			processFu_w(k.w_fu.sita, 2, k, list);
			
			processTo_w(k.w_to.ue, 0, k, list);
			processTo_w(k.w_to.mid, 1, k, list);
			processTo_w(k.w_to.sita, 2, k, list);
			
			processKyo_w(k.w_kyo.ue, 0, k, list);
			processKyo_w(k.w_kyo.mid, 1, k, list);
			processKyo_w(k.w_kyo.sita, 2, k, list);
			
			processNarikyo_w(k.w_narikyo.ue, 0, k, list);
			processNarikyo_w(k.w_narikyo.mid, 1, k, list);
			processNarikyo_w(k.w_narikyo.sita, 2, k, list);
			processKei_w(k.w_kei.ue, 0, k, list);
			processKei_w(k.w_kei.mid, 1, k, list);
			processKei_w(k.w_kei.sita, 2, k, list);
			processNarikei_w(k.w_narikei.ue, 0, k, list);
			processNarikei_w(k.w_narikei.mid, 1, k, list);
			processNarikei_w(k.w_narikei.sita, 2, k, list);
			processGin_w(k.w_gin.ue, 0, k, list);
			processGin_w(k.w_gin.mid, 1, k, list);
			processGin_w(k.w_gin.sita, 2, k, list);
			processNarigin_w(k.w_narigin.ue, 0, k, list);
			processNarigin_w(k.w_narigin.mid, 1, k, list);
			processNarigin_w(k.w_narigin.sita, 2, k, list);
	
			processKin_w(k.w_kin.ue, 0, k, list);
			processKin_w(k.w_kin.mid, 1, k, list);
			processKin_w(k.w_kin.sita, 2, k, list);
			processKaku_w(k.w_kaku.ue, 0, k, list);
			processKaku_w(k.w_kaku.mid, 1, k, list);
			processKaku_w(k.w_kaku.sita, 2, k, list);
			processUma_w(k.w_uma.ue, 0, k, list);
			processUma_w(k.w_uma.mid, 1, k, list);
			processUma_w(k.w_uma.sita, 2, k, list);
			processHisha_w(k.w_hisha.ue, 0, k, list);
			processHisha_w(k.w_hisha.mid, 1, k, list);
			processHisha_w(k.w_hisha.sita, 2, k, list);
			processRyu_w(k.w_ryu.ue, 0, k, list);
			processRyu_w(k.w_ryu.mid, 1, k, list);
			processRyu_w(k.w_ryu.sita, 2, k, list);
	
			processOu_w(k.w_ou.ue, 0, k, list);
			processOu_w(k.w_ou.mid, 1, k, list);
			processOu_w(k.w_ou.sita, 2, k, list);
	
			processUtsu_w(k, list);
		}
		return list;
	}

	private static final void processUtsu_b(Kyokumen k, List<Kyokumen> list)
			throws Exception {

		if (k.getFuNum_b() > 0 || k.getKyoNum_b() > 0 || k.getKeiNum_b() > 0 || k.getGinNum_b() > 0
				|| k.getKinNum_b() > 0 || k.getKakuNum_b() > 0
				|| k.getHishaNum_b() > 0) {
			List<IchiInf> utiBashos = Bitop.getUtiPoints(k);
			EachKoma fuPoint = Bitop.getFuUtiPoint_b(k);
			
			
			for (IchiInf ichi : utiBashos) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				
				if(k.getFuNum_b() > 0 && Bitop.bitCheck(fuPoint, komaIdx, np)){
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.b_fu.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.b_fu.mid |= np;
					} else {
						nk.b_fu.sita |= np;
					}
					nk.addHyoka(-Resources.Fu_tegoma);
					nk.addHyoka(Resources.Fu_ban);
					nk.delFu_b();
					nk.updAllKoma();
					list.add(nk);
				}
				
				if (k.getKyoNum_b() > 0
						&& !(komaIdx == 0 && np >= Bitop.SanDanMe)) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.b_kyo.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.b_kyo.mid |= np;
					} else {
						nk.b_kyo.sita |= np;
					}
					nk.addHyoka(-Resources.Kyo_tegoma);
					nk.addHyoka(Resources.Kyo_ban);
					nk.delKyo_b();
					nk.updAllKoma();
					list.add(nk);
				}
				if (k.getKeiNum_b() > 0
						&& !(komaIdx == 0 && np >= Bitop.NiDanMe)) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.b_kei.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.b_kei.mid |= np;
					} else {
						nk.b_kei.sita |= np;
					}
					nk.addHyoka(-Resources.Kei_tegoma);
					nk.addHyoka(Resources.Kei_ban);
					nk.delKei_b();
					nk.updAllKoma();
					list.add(nk);
				}
				if (k.getGinNum_b() > 0) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.b_gin.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.b_gin.mid |= np;
					} else {
						nk.b_gin.sita |= np;
					}
					nk.addHyoka(-Resources.Gin_tegoma);
					nk.addHyoka(Resources.Gin_ban);
					nk.delGin_b();
					nk.updAllKoma();
					list.add(nk);
				}
				if (k.getKinNum_b() > 0) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.b_kin.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.b_kin.mid |= np;
					} else {
						nk.b_kin.sita |= np;
					}
					nk.addHyoka(-Resources.Kin_tegoma);
					nk.addHyoka(Resources.Kin_ban);
					nk.delKin_b();
					nk.updAllKoma();
					list.add(nk);
				}
				if (k.getKakuNum_b() > 0) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.b_kaku.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.b_kaku.mid |= np;
					} else {
						nk.b_kaku.sita |= np;
					}
					nk.addHyoka(-Resources.Kaku_tegoma);
					nk.addHyoka(Resources.Kaku_ban);
					nk.delKaku_b();
					nk.updAllKoma();
					list.add(nk);
				}
				if (k.getHishaNum_b() > 0) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.b_hisha.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.b_hisha.mid |= np;
					} else {
						nk.b_hisha.sita |= np;
					}
					nk.addHyoka(-Resources.Hisha_tegoma);
					nk.addHyoka(Resources.Hisha_ban);
					nk.delHisha_b();
					nk.updAllKoma();
					list.add(nk);
				}

			}
		}
	}
	
	private static final void processUtsu_w(Kyokumen k, List<Kyokumen> list)
			throws Exception {

		if (k.getFuNum_w() > 0 && k.getKyoNum_w() > 0 || k.getKeiNum_w() > 0 || k.getGinNum_w() > 0
				|| k.getKinNum_w() > 0 || k.getKakuNum_w() > 0
				|| k.getHishaNum_w() > 0) {
			List<IchiInf> utiBashos = Bitop.getUtiPoints(k);
			EachKoma fuPoint = Bitop.getFuUtiPoint_w(k);
			for (IchiInf ichi : utiBashos) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				
				if(k.getFuNum_w() > 0 && Bitop.bitCheck(fuPoint, komaIdx, np)){
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.w_fu.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.w_fu.mid |= np;
					} else {
						nk.w_fu.sita |= np;
					}
					nk.addHyoka(Resources.Fu_tegoma);
					nk.addHyoka(-Resources.Fu_ban);
					nk.delFu_w();
					nk.updAllKoma();
					list.add(nk);
				}
				
				if (k.getKyoNum_w() > 0
						&& !(komaIdx == 2 && np < Bitop.NiDanMe)) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.w_kyo.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.w_kyo.mid |= np;
					} else {
						nk.w_kyo.sita |= np;
					}
					nk.addHyoka(Resources.Kyo_tegoma);
					nk.addHyoka(-Resources.Kyo_ban);
					nk.delKyo_w();
					nk.updAllKoma();
					list.add(nk);
				}
				if (k.getKeiNum_w() > 0
						&& !(komaIdx == 2 && np < Bitop.SanDanMe)) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.w_kei.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.w_kei.mid |= np;
					} else {
						nk.w_kei.sita |= np;
					}
					nk.addHyoka(Resources.Kei_tegoma);
					nk.addHyoka(-Resources.Kei_ban);
					nk.delKei_w();
					nk.updAllKoma();
					list.add(nk);
				}
				if (k.getGinNum_w() > 0) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.w_gin.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.w_gin.mid |= np;
					} else {
						nk.w_gin.sita |= np;
					}
					nk.addHyoka(Resources.Gin_tegoma);
					nk.addHyoka(-Resources.Gin_ban);
					nk.delGin_w();
					nk.updAllKoma();
					list.add(nk);
				}
				if (k.getKinNum_w() > 0) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.w_kin.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.w_kin.mid |= np;
					} else {
						nk.w_kin.sita |= np;
					}
					nk.addHyoka(Resources.Kin_tegoma);
					nk.addHyoka(-Resources.Kin_ban);
					nk.delKin_w();
					nk.updAllKoma();
					list.add(nk);
				}
				if (k.getKakuNum_w() > 0) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.w_kaku.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.w_kaku.mid |= np;
					} else {
						nk.w_kaku.sita |= np;
					}
					nk.addHyoka(Resources.Kaku_tegoma);
					nk.addHyoka(-Resources.Kaku_ban);
					nk.delKaku_w();
					nk.updAllKoma();
					list.add(nk);
				}
				if (k.getHishaNum_w() > 0) {
					Kyokumen nk = new Kyokumen(k);
					if (komaIdx == Bitop.KOMAIDX_UE) {
						nk.w_hisha.ue |= np;
					} else if (komaIdx == Bitop.KOMAIDX_MID) {
						nk.w_hisha.mid |= np;
					} else {
						nk.w_hisha.sita |= np;
					}
					nk.delHisha_w();
					nk.addHyoka(Resources.Hisha_tegoma);
					nk.addHyoka(-Resources.Hisha_ban);
					nk.updAllKoma();
					list.add(nk);
				}
			}
		}
	}


	private static final void torute_b(int komaIdx, int np, Kyokumen nk) throws Exception {
		if (Bitop.existKoma_w(nk, komaIdx, np)) {
			// 
			int komaNum_w = nk.getKomaNumber_w(komaIdx, np);
			EachKoma w_koma = nk.getKoma_w(komaNum_w);
			w_koma.del(komaIdx, np);
			int tegomaNum_w = Resources.getTegomaNumber(komaNum_w);
			nk.addTegoma_b(tegomaNum_w);
			nk.addHyoka(Resources.getKomaValue(komaNum_w)
					+ Resources.getTegomaValue(tegomaNum_w));
		}
	}

	private static final void torute_w(int komaIdx, int np, Kyokumen nk) throws Exception{
		if (Bitop.existKoma_b(nk, komaIdx, np)) {
			// 
			int komaNum_b = nk.getKomaNumber_b(komaIdx, np);
			EachKoma b_koma = nk.getKoma_b(komaNum_b);
			b_koma.del(komaIdx, np);
			int tegomaNum = Resources.getTegomaNumber(komaNum_b);
			nk.addTegoma_w(tegomaNum);
			nk.addHyoka(-Resources.getKomaValue(komaNum_b)
					- Resources.getTegomaValue(tegomaNum));
		}
	}

	private static final void processTo_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKinMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.b_to.del(orgKomaIdx, p);
				nk.b_to.add(komaIdx, np);
				torute_b(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}

	private static final void processTo_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKinMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.w_to.del(orgKomaIdx, p);
				nk.w_to.add(komaIdx, np);
				torute_w(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}

	private static final void processNarikyo_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKinMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.b_narikyo.del(orgKomaIdx, p);
				nk.b_narikyo.add(komaIdx, np);
				torute_b(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}
	
	private static final void processNarikyo_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKinMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.w_narikyo.del(orgKomaIdx, p);
				nk.w_narikyo.add(komaIdx, np);
				torute_w(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}

	private static final void processNarikei_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKinMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.b_narikei.del(orgKomaIdx, p);
				nk.b_narikei.add(komaIdx, np);
				torute_b(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}
	
	private static final void processNarikei_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKinMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.w_narikei.del(orgKomaIdx, p);
				nk.w_narikei.add(komaIdx, np);
				torute_w(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}

	private static final void processNarigin_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKinMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.b_narigin.del(orgKomaIdx, p);
				nk.b_narigin.add(komaIdx, np);
				torute_b(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}

	private static final void processNarigin_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKinMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.w_narigin.del(orgKomaIdx, p);
				nk.w_narigin.add(komaIdx, np);
				torute_w(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}
	
	private static final void processKin_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKinMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.b_kin.del(orgKomaIdx, p);
				nk.b_kin.add(komaIdx, np);
				torute_b(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}
	
	private static final void processKin_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKinMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.w_kin.del(orgKomaIdx, p);
				nk.w_kin.add(komaIdx, np);
				torute_w(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}

	private static final void processUma_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getUmaMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.b_uma.del(orgKomaIdx, p);
				nk.b_uma.add(komaIdx, np);
				torute_b(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}
	
	private static final void processUma_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getUmaMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.w_uma.del(orgKomaIdx, p);
				nk.w_uma.add(komaIdx, np);
				torute_w(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}

	private static final void processRyu_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getRyuMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.b_ryu.del(orgKomaIdx, p);
				nk.b_ryu.add(komaIdx, np);
				torute_b(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}
	
	private static final void processRyu_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getRyuMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.w_ryu.del(orgKomaIdx, p);
				nk.w_ryu.add(komaIdx, np);
				torute_w(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}

	private static final void processOu_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getOuMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.b_ou.del(orgKomaIdx, p);
				nk.b_ou.add(komaIdx, np);
				torute_b(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);

			}
		}
	}
	
	private static final void processOu_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getOuMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				Kyokumen nk = new Kyokumen(k);
				nk.w_ou.del(orgKomaIdx, p);
				nk.w_ou.add(komaIdx, np);
				torute_w(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);

			}
		}
	}

	private static final void processHisha_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getHishaMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				if (komaIdx == Bitop.KOMAIDX_UE) {
					// 
					Kyokumen nk = new Kyokumen(k);
					nk.b_hisha.del(orgKomaIdx, p);
					nk.b_ryu.add(komaIdx, np);
					nk.addHyoka(-Resources
							.getKomaValue(Resources.KomaNum_HISHA));
					nk.addHyoka(Resources.getKomaValue(Resources.KomaNum_RYU));
					torute_b(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				} else {
					// Ȃ(ꉞAGAɍsKƂBi܂ɑłl߂ƂłȂȂǂꍇj
					Kyokumen nk = new Kyokumen(k);
					nk.b_hisha.del(orgKomaIdx, p);
					nk.b_hisha.add(komaIdx, np);
					torute_b(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}
			}
		}
	}
	
	private static final void processHisha_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getHishaMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				if (komaIdx == Bitop.KOMAIDX_SITA) {
					// 
					Kyokumen nk = new Kyokumen(k);
					nk.w_hisha.del(orgKomaIdx, p);
					nk.w_ryu.add(komaIdx, np);
					nk.addHyoka(Resources
							.getKomaValue(Resources.KomaNum_HISHA));
					nk.addHyoka(-Resources.getKomaValue(Resources.KomaNum_RYU));
					torute_w(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				} else {
					// Ȃ(ꉞAGAɍsKƂBi܂ɑłl߂ƂłȂȂǂꍇj
					Kyokumen nk = new Kyokumen(k);
					nk.w_hisha.del(orgKomaIdx, p);
					nk.w_hisha.add(komaIdx, np);
					torute_w(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}
			}
		}
	}

	private static final void processKaku_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKakuMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				if (komaIdx == Bitop.KOMAIDX_UE) {
					// 
					Kyokumen nk = new Kyokumen(k);
					nk.b_kaku.del(orgKomaIdx, p);
					nk.b_uma.add(komaIdx, np);
					nk.addHyoka(-Resources.getKomaValue(Resources.KomaNum_KAKU));
					nk.addHyoka(Resources.getKomaValue(Resources.KomaNum_UMA));
					torute_b(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				} else {
					// Ȃ(ꉞAGAɍsKƂBi܂ɑłl߂ƂłȂȂǂꍇj
					Kyokumen nk = new Kyokumen(k);
					nk.b_kaku.del(orgKomaIdx, p);
					nk.b_kaku.add(komaIdx, np);
					torute_b(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}
			}
		}
	}
	
	private static final void processKaku_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKakuMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				if (komaIdx == Bitop.KOMAIDX_SITA) {
					// 
					Kyokumen nk = new Kyokumen(k);
					nk.w_kaku.del(orgKomaIdx, p);
					nk.w_uma.add(komaIdx, np);
					nk.addHyoka(Resources.getKomaValue(Resources.KomaNum_KAKU));
					nk.addHyoka(-Resources.getKomaValue(Resources.KomaNum_UMA));
					torute_w(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				} else {
					// Ȃ(ꉞAGAɍsKƂBi܂ɑłl߂ƂłȂȂǂꍇj
					Kyokumen nk = new Kyokumen(k);
					nk.w_kaku.del(orgKomaIdx, p);
					nk.w_kaku.add(komaIdx, np);
					torute_w(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}
			}
		}
	}

	private static final void processFu_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getFuMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				if (komaIdx == 0) {
					// 
					Kyokumen nk = new Kyokumen(k);
					nk.b_fu.del(orgKomaIdx, p);
					nk.b_to.add(komaIdx, np);
					nk.addHyoka(-Resources.getKomaValue(Resources.KomaNum_FU));
					nk.addHyoka(Resources.getKomaValue(Resources.KomaNum_TO));
					torute_b(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				} else {
					// Ȃ(Ȃ鎞͕KƂj
					Kyokumen nk = new Kyokumen(k);
					nk.b_fu.del(orgKomaIdx, p);
					nk.b_fu.add(komaIdx, np);
					torute_b(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}
			}
		}
	}

	private static final void processFu_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getFuMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				if (komaIdx == Bitop.KOMAIDX_SITA) {
					// 
					Kyokumen nk = new Kyokumen(k);
					nk.w_fu.del(orgKomaIdx, p);
					nk.w_to.add(komaIdx, np);
					nk.addHyoka(Resources.getKomaValue(Resources.KomaNum_FU));
					nk.addHyoka(-Resources.getKomaValue(Resources.KomaNum_TO));
					torute_w(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				} else {
					// Ȃ(Ȃ鎞͕KƂj
					Kyokumen nk = new Kyokumen(k);
					nk.w_fu.del(orgKomaIdx, p);
					nk.w_fu.add(komaIdx, np);
					torute_w(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}
			}
		}
	}

	private static final void processGin_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getGinMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				if (komaIdx == 0) {
					// 
					Kyokumen nk = new Kyokumen(k);
					nk.b_gin.del(orgKomaIdx, p);
					nk.b_narigin.add(komaIdx, np);
					nk.addHyoka(-Resources.getKomaValue(Resources.KomaNum_GIN));
					nk.addHyoka(Resources
							.getKomaValue(Resources.KomaNum_NARIGIN));
					torute_b(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}

				// Ȃ
				Kyokumen nk = new Kyokumen(k);
				nk.b_gin.del(orgKomaIdx, p);
				nk.b_gin.add(komaIdx, np);
				torute_b(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}
	
	private static final void processGin_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getGinMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				if (komaIdx == Bitop.KOMAIDX_SITA) {
					// 
					Kyokumen nk = new Kyokumen(k);
					nk.w_gin.del(orgKomaIdx, p);
					nk.w_narigin.add(komaIdx, np);
					nk.addHyoka(Resources.getKomaValue(Resources.KomaNum_GIN));
					nk.addHyoka(-Resources
							.getKomaValue(Resources.KomaNum_NARIGIN));
					torute_w(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}

				// Ȃ
				Kyokumen nk = new Kyokumen(k);
				nk.w_gin.del(orgKomaIdx, p);
				nk.w_gin.add(komaIdx, np);
				torute_w(komaIdx, np, nk);
				nk.updAllKoma();
				list.add(nk);
			}
		}
	}

	private static final void processKei_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;

			int komaIdx = orgKomaIdx;

			if (p >= 1 << 9) {
				komaIdx--;
			}
			if (p != 1 << 8 && p != 1 << 17 && p != 1 << 26) {
				int np = 0;
				if (p >= 1 << 18) {
					np = p >> 8;
				} else {
					np = p << 10;
				}
				if(k.checkExist_b(komaIdx, np) == null){
					if (komaIdx > 0 || komaIdx == 0 && np < 1 << 9) {
						// Ȃ
						Kyokumen nk = new Kyokumen(k);
						nk.b_kei.del(orgKomaIdx, p);
						nk.b_kei.add(komaIdx, np);
						torute_b(komaIdx, np, nk);
						nk.updAllKoma();
						list.add(nk);
					}
					if (komaIdx == 0) {
						// 
						Kyokumen nk = new Kyokumen(k);
						nk.b_kei.del(orgKomaIdx, p);
						nk.b_narikei.add(komaIdx, np);
						nk.addHyoka(-Resources.getKomaValue(Resources.KomaNum_KEI));
						nk.addHyoka(Resources
								.getKomaValue(Resources.KomaNum_NARIKEI));
						torute_b(komaIdx, np, nk);
						nk.updAllKoma();
						list.add(nk);
					}
				}
			}
			if (p != 1 && p != 1 << 9 && p != 1 << 18) {
				int np = 0;
				if (p >= 1 << 18) {
					np = p >> 10;
				} else {
					np = p << 8;
				}
				if(k.checkExist_b(komaIdx, np) == null){
					if (komaIdx > 0 || komaIdx == 0 && np < 1 << 9) {
						// Ȃ
						Kyokumen nk = new Kyokumen(k);
						nk.b_kei.del(orgKomaIdx, p);
						nk.b_kei.add(komaIdx, np);
						torute_b(komaIdx, np, nk);
						nk.updAllKoma();
						list.add(nk);
					}
					if (komaIdx == 0) {
						// 
						Kyokumen nk = new Kyokumen(k);
						nk.b_kei.del(orgKomaIdx, p);
						nk.b_narikei.add(komaIdx, np);
						nk.addHyoka(-Resources.getKomaValue(Resources.KomaNum_KEI));
						nk.addHyoka(Resources
								.getKomaValue(Resources.KomaNum_NARIKEI));
						torute_b(komaIdx, np, nk);
						nk.updAllKoma();
						list.add(nk);
					}
				}
			}
		}
	}
	
	private static final void processKei_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;

			int komaIdx = orgKomaIdx;

			if (p < Bitop.SanDanMe) {
				komaIdx++;
			}
			if(komaIdx > Bitop.KOMAIDX_SITA){
				continue;
			}
			if (p != Bitop.LEFTONE && p != Bitop.LEFTTWO && p != Bitop.LEFTTHREE) {
				int np = 0;
				if (p < Bitop.SanDanMe) {
					np = p << 10;
				} else {
					np = p >> 18;
				}
				if(k.checkExist_w(komaIdx, np) == null){
					if (!(komaIdx != Bitop.KOMAIDX_SITA && np < Bitop.SanDanMe)) {
						// Ȃ
						Kyokumen nk = new Kyokumen(k);
						nk.w_kei.del(orgKomaIdx, p);
						nk.w_kei.add(komaIdx, np);
						torute_w(komaIdx, np, nk);
						nk.updAllKoma();
						list.add(nk);
					}
					if (komaIdx == Bitop.KOMAIDX_SITA) {
						// 
						Kyokumen nk = new Kyokumen(k);
						nk.w_kei.del(orgKomaIdx, p);
						nk.w_narikei.add(komaIdx, np);
						nk.addHyoka(Resources.getKomaValue(Resources.KomaNum_KEI));
						nk.addHyoka(-Resources
								.getKomaValue(Resources.KomaNum_NARIKEI));
						torute_w(komaIdx, np, nk);
						nk.updAllKoma();
						list.add(nk);
					}
				}
			}
			if (p != Bitop.RIGHTONE && p != Bitop.RIGHTTWO && p != Bitop.RIGHTTHREE) {
				int np = 0;
				if (p < Bitop.SanDanMe) {
					np = p << 8;
				} else {
					np = p >> 19;
				}
				if(k.checkExist_w(komaIdx, np) == null){
					if (!(komaIdx == Bitop.KOMAIDX_SITA && np < Bitop.SanDanMe) ) {
						// Ȃ
						Kyokumen nk = new Kyokumen(k);
						nk.w_kei.del(orgKomaIdx, p);
						nk.w_kei.add(komaIdx, np);
						torute_w(komaIdx, np, nk);
						nk.updAllKoma();
						list.add(nk);
					}
					if (komaIdx == Bitop.KOMAIDX_SITA) {
						// 
						Kyokumen nk = new Kyokumen(k);
						nk.w_kei.del(orgKomaIdx, p);
						nk.w_narikei.add(komaIdx, np);
						nk.addHyoka(Resources.getKomaValue(Resources.KomaNum_KEI));
						nk.addHyoka(-Resources
								.getKomaValue(Resources.KomaNum_NARIKEI));
						torute_w
						(komaIdx, np, nk);
						nk.updAllKoma();
						list.add(nk);
					}
				}
			}
		}
	}

	private static final void processKyo_b(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKyoMovePoints_b(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				if (komaIdx == 0) {
					// 
					Kyokumen nk = new Kyokumen(k);
					nk.b_kyo.del(orgKomaIdx, p);
					nk.b_narikyo.add(komaIdx, np);
					nk.addHyoka(-Resources.getKomaValue(Resources.KomaNum_GIN));
					nk.addHyoka(Resources
							.getKomaValue(Resources.KomaNum_NARIGIN));
					torute_b(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}

				// Ȃ
				if (!(komaIdx == Bitop.KOMAIDX_UE && np >= Bitop.SanDanMe)) {
					Kyokumen nk = new Kyokumen(k);
					nk.b_kyo.del(orgKomaIdx, p);
					nk.b_kyo.add(komaIdx, np);
					torute_b(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}
			}
		}
	}
	
	private static final void processKyo_w(int b, int orgKomaIdx, Kyokumen k,
			List<Kyokumen> list) throws Exception {
		while (b > 0) {
			int p = Integer.highestOneBit(b);
			b ^= p;
			List<IchiInf> ichis = Bitop.getKyoMovePoints_w(k, orgKomaIdx, p);
			for (IchiInf ichi : ichis) {
				int komaIdx = ichi.komaIdx;
				int np = ichi.p;
				if (komaIdx == 2) {
					// 
					Kyokumen nk = new Kyokumen(k);
					nk.w_kyo.del(orgKomaIdx, p);
					nk.w_narikyo.add(komaIdx, np);
					nk.addHyoka(Resources.getKomaValue(Resources.KomaNum_GIN));
					nk.addHyoka(-Resources
							.getKomaValue(Resources.KomaNum_NARIGIN));
					torute_w(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}

				// Ȃ
				if (!(komaIdx == Bitop.KOMAIDX_SITA && np < Bitop.NiDanMe)) {
					Kyokumen nk = new Kyokumen(k);
					nk.w_kyo.del(orgKomaIdx, p);
					nk.w_kyo.add(komaIdx, np);
					torute_w(komaIdx, np, nk);
					nk.updAllKoma();
					list.add(nk);
				}
			}
		}
	}

}
