package com.rogerfgm;

import java.io.PrintStream;

public class Kyokumen implements Cloneable{
	EachKoma b_fu;
	EachKoma b_to;
	EachKoma b_kyo;
	EachKoma b_narikyo;
	EachKoma b_kei;
	EachKoma b_narikei;
	EachKoma b_gin;
	EachKoma b_narigin;
	EachKoma b_kin;
	EachKoma b_kaku;
	EachKoma b_uma;
	EachKoma b_hisha;
	EachKoma b_ryu;
	EachKoma b_ou;
	
	EachKoma b_all;
	
	EachKoma w_fu;
	EachKoma w_to;
	EachKoma w_kyo;
	EachKoma w_narikyo;
	EachKoma w_kei;
	EachKoma w_narikei;
	EachKoma w_gin;
	EachKoma w_narigin;
	EachKoma w_kin;
	EachKoma w_kaku;
	EachKoma w_uma;
	EachKoma w_hisha;
	EachKoma w_ryu;
	EachKoma w_ou;
	
	EachKoma w_all;
	
	EachKoma bw_all;
	
	int b_tegoma;
	int w_tegoma;
	int hyouka;
	
	public void updAllKoma(){
		b_all.ue = b_all.mid = b_all.sita = w_all.ue = w_all.mid = w_all.sita = 0;
		bw_all.ue = bw_all.mid = bw_all.sita = 0;
		
		b_all.ue |= b_fu.ue;
		b_all.ue |= b_to.ue;
		b_all.ue |= b_kyo.ue;
		b_all.ue |= b_narikyo.ue;
		b_all.ue |= b_kei.ue;
		b_all.ue |= b_narikei.ue;
		b_all.ue |= b_gin.ue;
		b_all.ue |= b_narigin.ue;
		b_all.ue |= b_kin.ue;
		b_all.ue |= b_kaku.ue;
		b_all.ue |= b_uma.ue;
		b_all.ue |= b_hisha.ue;
		b_all.ue |= b_ryu.ue;
		b_all.ue |= b_ou.ue;
		
		b_all.mid |= b_fu.mid;
		b_all.mid |= b_to.mid;
		b_all.mid |= b_kyo.mid;
		b_all.mid |= b_narikyo.mid;
		b_all.mid |= b_kei.mid;
		b_all.mid |= b_narikei.mid;
		b_all.mid |= b_gin.mid;
		b_all.mid |= b_narigin.mid;
		b_all.mid |= b_kin.mid;
		b_all.mid |= b_kaku.mid;
		b_all.mid |= b_uma.mid;
		b_all.mid |= b_hisha.mid;
		b_all.mid |= b_ryu.mid;
		b_all.mid |= b_ou.mid;
		
		b_all.sita |= b_fu.sita;
		b_all.sita |= b_to.sita;
		b_all.sita |= b_kyo.sita;
		b_all.sita |= b_narikyo.sita;
		b_all.sita |= b_kei.sita;
		b_all.sita |= b_narikei.sita;
		b_all.sita |= b_gin.sita;
		b_all.sita |= b_narigin.sita;
		b_all.sita |= b_kin.sita;
		b_all.sita |= b_kaku.sita;
		b_all.sita |= b_uma.sita;
		b_all.sita |= b_hisha.sita;
		b_all.sita |= b_ryu.sita;
		b_all.sita |= b_ou.sita;
		
		w_all.ue |= w_fu.ue;
		w_all.ue |= w_to.ue;
		w_all.ue |= w_kyo.ue;
		w_all.ue |= w_narikyo.ue;
		w_all.ue |= w_kei.ue;
		w_all.ue |= w_narikei.ue;
		w_all.ue |= w_gin.ue;
		w_all.ue |= w_narigin.ue;
		w_all.ue |= w_kin.ue;
		w_all.ue |= w_kaku.ue;
		w_all.ue |= w_uma.ue;
		w_all.ue |= w_hisha.ue;
		w_all.ue |= w_ryu.ue;
		w_all.ue |= w_ou.ue;
		
		w_all.mid |= w_fu.mid;
		w_all.mid |= w_to.mid;
		w_all.mid |= w_kyo.mid;
		w_all.mid |= w_narikyo.mid;
		w_all.mid |= w_kei.mid;
		w_all.mid |= w_narikei.mid;
		w_all.mid |= w_gin.mid;
		w_all.mid |= w_narigin.mid;
		w_all.mid |= w_kin.mid;
		w_all.mid |= w_kaku.mid;
		w_all.mid |= w_uma.mid;
		w_all.mid |= w_hisha.mid;
		w_all.mid |= w_ryu.mid;
		w_all.mid |= w_ou.mid;
		
		w_all.sita |= w_fu.sita;
		w_all.sita |= w_to.sita;
		w_all.sita |= w_kyo.sita;
		w_all.sita |= w_narikyo.sita;
		w_all.sita |= w_kei.sita;
		w_all.sita |= w_narikei.sita;
		w_all.sita |= w_gin.sita;
		w_all.sita |= w_narigin.sita;
		w_all.sita |= w_kin.sita;
		w_all.sita |= w_kaku.sita;
		w_all.sita |= w_uma.sita;
		w_all.sita |= w_hisha.sita;
		w_all.sita |= w_ryu.sita;
		w_all.sita |= w_ou.sita;
		
		bw_all.ue |= b_all.ue;
		bw_all.ue |= w_all.ue;
		bw_all.mid |= b_all.mid;
		bw_all.mid |= w_all.mid;
		bw_all.sita |= b_all.sita;
		bw_all.sita |= w_all.sita;
	}
	
	public void updateHyoka(){
		hyouka = 0;
		hyouka += ( Bitop.cntBit(b_fu.ue) + Bitop.cntBit(b_fu.mid) + Bitop.cntBit(b_fu.sita) 
				- Bitop.cntBit(w_fu.ue) - Bitop.cntBit(w_fu.mid) - Bitop.cntBit(w_fu.sita) ) * Resources.Fu_ban;
		hyouka += ( Bitop.cntBit(b_to.ue) + Bitop.cntBit(b_to.mid) + Bitop.cntBit(b_to.sita) 
				- Bitop.cntBit(w_to.ue) - Bitop.cntBit(w_to.mid) - Bitop.cntBit(w_to.sita) ) * Resources.To_ban;
		hyouka += ( Bitop.cntBit(b_kyo.ue) + Bitop.cntBit(b_kyo.mid) + Bitop.cntBit(b_kyo.sita) 
				- Bitop.cntBit(w_kyo.ue) - Bitop.cntBit(w_kyo.mid) - Bitop.cntBit(w_kyo.sita) ) * Resources.Kyo_ban;
		hyouka += ( Bitop.cntBit(b_narikyo.ue) + Bitop.cntBit(b_narikyo.mid) + Bitop.cntBit(b_narikyo.sita) 
				- Bitop.cntBit(w_narikyo.ue) - Bitop.cntBit(w_narikyo.mid) - Bitop.cntBit(w_narikyo.sita) ) * Resources.NariKyo_ban;
		hyouka += ( Bitop.cntBit(b_kei.ue) + Bitop.cntBit(b_kei.mid) + Bitop.cntBit(b_kei.sita) 
				- Bitop.cntBit(w_kei.ue) - Bitop.cntBit(w_kei.mid) - Bitop.cntBit(w_kei.sita) ) * Resources.Kei_ban;
		hyouka += ( Bitop.cntBit(b_narikei.ue) + Bitop.cntBit(b_narikei.mid) + Bitop.cntBit(b_narikei.sita) 
				- Bitop.cntBit(w_narikei.ue) - Bitop.cntBit(w_narikei.mid) - Bitop.cntBit(w_narikei.sita) ) * Resources.NariKei_ban;
		hyouka += ( Bitop.cntBit(b_gin.ue) + Bitop.cntBit(b_gin.mid) + Bitop.cntBit(b_gin.sita) 
				- Bitop.cntBit(w_gin.ue) - Bitop.cntBit(w_gin.mid) - Bitop.cntBit(w_gin.sita) ) * Resources.Gin_ban;
		hyouka += ( Bitop.cntBit(b_narigin.ue) + Bitop.cntBit(b_narigin.mid) + Bitop.cntBit(b_narigin.sita) 
				- Bitop.cntBit(w_narigin.ue) - Bitop.cntBit(w_narigin.mid) - Bitop.cntBit(w_narigin.sita) ) * Resources.NariGin_ban;
		hyouka += ( Bitop.cntBit(b_kaku.ue) + Bitop.cntBit(b_kaku.mid) + Bitop.cntBit(b_kaku.sita) 
				- Bitop.cntBit(w_kaku.ue) - Bitop.cntBit(w_kaku.mid) - Bitop.cntBit(w_kaku.sita) ) * Resources.Kaku_ban;
		hyouka += ( Bitop.cntBit(b_uma.ue) + Bitop.cntBit(b_uma.mid) + Bitop.cntBit(b_uma.sita) 
				- Bitop.cntBit(w_uma.ue) - Bitop.cntBit(w_uma.mid) - Bitop.cntBit(w_uma.sita) ) * Resources.Uma_ban;
		hyouka += ( Bitop.cntBit(b_hisha.ue) + Bitop.cntBit(b_hisha.mid) + Bitop.cntBit(b_hisha.sita) 
				- Bitop.cntBit(w_hisha.ue) - Bitop.cntBit(w_hisha.mid) - Bitop.cntBit(w_hisha.sita) ) * Resources.Hisha_ban;
		hyouka += ( Bitop.cntBit(b_ryu.ue) + Bitop.cntBit(b_ryu.mid) + Bitop.cntBit(b_ryu.sita) 
				- Bitop.cntBit(w_ryu.ue) - Bitop.cntBit(w_ryu.mid) - Bitop.cntBit(w_ryu.sita) ) * Resources.Ryu_ban;
		hyouka += ( Bitop.cntBit(b_ou.ue) + Bitop.cntBit(b_ou.mid) + Bitop.cntBit(b_ou.sita) 
				- Bitop.cntBit(w_ou.ue) - Bitop.cntBit(w_ou.mid) - Bitop.cntBit(w_ou.sita) ) * Resources.Oh;
		
		hyouka += (getFuNum_b() - getFuNum_w()) * Resources.Fu_tegoma;
		hyouka += (getKyoNum_b() - getKyoNum_w()) * Resources.Kyo_tegoma;
		hyouka += (getKeiNum_b() - getKeiNum_w()) * Resources.Kei_tegoma;
		hyouka += (getGinNum_b() - getGinNum_w()) * Resources.Gin_tegoma;
		hyouka += (getKinNum_b() - getKinNum_w()) * Resources.Kin_tegoma;
		hyouka += (getKakuNum_b() - getKakuNum_w()) * Resources.Kaku_tegoma;
		hyouka += (getHishaNum_b() - getHishaNum_w()) * Resources.Hisha_tegoma;
	}
	
	
	
	public Kyokumen(){
		b_fu = new EachKoma();
		b_to = new EachKoma();
		b_kyo = new EachKoma();
		b_narikyo = new EachKoma();
		b_kei = new EachKoma();
		b_narikei = new EachKoma();
		b_gin = new EachKoma();
		b_narigin = new EachKoma();
		b_kin = new EachKoma();
		b_kaku = new EachKoma();
		b_uma = new EachKoma();
		b_hisha = new EachKoma();
		b_ryu = new EachKoma();
		b_ou = new EachKoma();
		b_all = new EachKoma();
		w_fu = new EachKoma();
		w_to = new EachKoma();
		w_kyo = new EachKoma();
		w_narikyo = new EachKoma();
		w_kei = new EachKoma();
		w_narikei = new EachKoma();
		w_gin = new EachKoma();
		w_narigin = new EachKoma();
		w_kin = new EachKoma();
		w_kaku = new EachKoma();
		w_uma = new EachKoma();
		w_hisha = new EachKoma();
		w_ryu = new EachKoma();
		w_ou = new EachKoma();
		w_all = new EachKoma();
		bw_all = new EachKoma();
		b_tegoma = 0;
		w_tegoma = 0;
		hyouka = 0;
	}

	public void addHyoka(int v){
		hyouka += v;
	}
	
	public Kyokumen(Kyokumen k) throws CloneNotSupportedException{
		b_fu = (EachKoma)k.b_fu.clone();
		b_to = (EachKoma)k.b_to.clone();
		b_kyo = (EachKoma)k.b_kyo.clone();
		b_narikyo = (EachKoma)k.b_narikyo.clone();
		b_kei = (EachKoma)k.b_kei.clone();
		b_narikei = (EachKoma)k.b_narikei.clone();;
		b_gin = (EachKoma)k.b_gin.clone();
		b_narigin = (EachKoma)k.b_narigin.clone();
		b_kin = (EachKoma)k.b_kin.clone();
		b_kaku = (EachKoma)k.b_kaku.clone();
		b_uma = (EachKoma)k.b_uma.clone();
		b_hisha = (EachKoma)k.b_hisha.clone();
		b_ryu = (EachKoma)k.b_ryu.clone();;
		b_ou = (EachKoma)k.b_ou.clone();
		b_all = (EachKoma)k.b_all.clone();
		
		w_fu = (EachKoma)k.w_fu.clone();
		w_to = (EachKoma)k.w_to.clone();
		w_kyo = (EachKoma)k.w_kyo.clone();
		w_narikyo = (EachKoma)k.w_narikyo.clone();
		w_kei = (EachKoma)k.w_kei.clone();
		w_narikei = (EachKoma)k.w_narikei.clone();;
		w_gin = (EachKoma)k.w_gin.clone();
		w_narigin = (EachKoma)k.w_narigin.clone();
		w_kin = (EachKoma)k.w_kin.clone();
		w_kaku = (EachKoma)k.w_kaku.clone();
		w_uma = (EachKoma)k.w_uma.clone();
		w_hisha = (EachKoma)k.w_hisha.clone();
		w_ryu = (EachKoma)k.w_ryu.clone();;
		w_ou = (EachKoma)k.w_ou.clone();
		w_all = (EachKoma)k.w_all.clone();
		bw_all = (EachKoma)k.bw_all.clone();
		b_tegoma = k.b_tegoma;
		w_tegoma = k.w_tegoma;
		hyouka = k.hyouka;
	}
	
	public EachKoma getKoma_b(int komaNum){
		if(komaNum == Resources.KomaNum_FU){
			return b_fu;
		}
		if(komaNum == Resources.KomaNum_TO){
			return b_to;
		}
		if(komaNum == Resources.KomaNum_KYO){
			return b_kyo;
		}
		if(komaNum == Resources.KomaNum_NARIKYO){
			return b_narikyo;
		}
		if(komaNum == Resources.KomaNum_KEI){
			return b_kei;
		}
		if(komaNum == Resources.KomaNum_NARIKEI){
			return b_narikei;
		}
		if(komaNum == Resources.KomaNum_GIN){
			return b_gin;
		}
		if(komaNum == Resources.KomaNum_NARIGIN){
			return b_narigin;
		}
		if(komaNum == Resources.KomaNum_KIN){
			return b_kin;
		}
		if(komaNum == Resources.KomaNum_KAKU){
			return b_kaku;
		}
		if(komaNum == Resources.KomaNum_UMA){
			return b_uma;
		}
		if(komaNum == Resources.KomaNum_HISHA){
			return b_hisha;
		}
		if(komaNum == Resources.KomaNum_RYU){
			return b_ryu;
		}
		if(komaNum == Resources.KomaNum_OU){
			return b_ou;
		}
		return null;
	}
	
	public EachKoma getKoma_w(int komaNum){
		if(komaNum == Resources.KomaNum_FU){
			return w_fu;
		}
		if(komaNum == Resources.KomaNum_TO){
			return w_to;
		}
		if(komaNum == Resources.KomaNum_KYO){
			return w_kyo;
		}
		if(komaNum == Resources.KomaNum_NARIKYO){
			return w_narikyo;
		}
		if(komaNum == Resources.KomaNum_KEI){
			return w_kei;
		}
		if(komaNum == Resources.KomaNum_NARIKEI){
			return w_narikei;
		}
		if(komaNum == Resources.KomaNum_GIN){
			return w_gin;
		}
		if(komaNum == Resources.KomaNum_NARIGIN){
			return w_narigin;
		}
		if(komaNum == Resources.KomaNum_KIN){
			return w_kin;
		}
		if(komaNum == Resources.KomaNum_KAKU){
			return w_kaku;
		}
		if(komaNum == Resources.KomaNum_UMA){
			return w_uma;
		}
		if(komaNum == Resources.KomaNum_HISHA){
			return w_hisha;
		}
		if(komaNum == Resources.KomaNum_RYU){
			return w_ryu;
		}
		if(komaNum == Resources.KomaNum_OU){
			return w_ou;
		}
		return null;
	}
	
	public final boolean checkExist(int komaIdx, int p){
		if(komaIdx == 0){
			return (bw_all.ue & p) > 0;
		}
		else if(komaIdx == 1){
			return (bw_all.mid & p) > 0;
		}
		else{
			return (bw_all.sita & p) > 0;
		}
	}

	/**
	 * ̒n_ɃR}݂邩`FbNB
	 * ݂炻̃R}AȂnullԂB
	 * @param d@ue 0, mid 1, sita 2
	 * @param p `FbNrbgʒu
	 * @return
	 */
	public EachKoma checkExist_b(int komaIdx, int p){
		if(b_fu.exist(komaIdx, p)){
			return b_fu;
		}
		if(b_kyo.exist(komaIdx, p)){
			return b_kyo;
		}
		if(b_kei.exist(komaIdx, p)){
			return b_kei;
		}
		if(b_gin.exist(komaIdx, p)){
			return b_gin;
		}
		if(b_kin.exist(komaIdx, p)){
			return b_kin;
		}
		if(b_kaku.exist(komaIdx, p)){
			return b_kaku;
		}
		if(b_hisha.exist(komaIdx, p)){
			return b_hisha;
		}
		if(b_ou.exist(komaIdx, p)){
			return b_ou;
		}
		if(b_to.exist(komaIdx, p)){
			return b_to;
		}
		if(b_narikyo.exist(komaIdx, p)){
			return b_narikyo;
		}
		if(b_narikei.exist(komaIdx, p)){
			return b_narikei;
		}
		if(b_narigin.exist(komaIdx, p)){
			return b_narigin;
		}
		if(b_uma.exist(komaIdx, p)){
			return b_uma;
		}
		if(b_ryu.exist(komaIdx, p)){
			return b_ryu;
		}
		
		return null;
	}
	
	public final boolean existFu_b(int komaIdx, int p){
		if(komaIdx == 0){
			return (b_fu.ue & p) > 0;
		}
		else if(komaIdx == 1){
			return (b_fu.mid & p) > 0;
		}
		return (b_fu.sita & p) > 0;
	}
	
	public final boolean existFu_w(int komaIdx, int p){
		if(komaIdx == 0){
			return (w_fu.ue & p) > 0;
		}
		else if(komaIdx == 1){
			return (w_fu.mid & p) > 0;
		}
		return (w_fu.sita & p) > 0;
	}
	
	/**
	 * ̈ʒuɑ݂R}ԍԂB
	 * Ȃ-1
	 * @param d
	 * @param p
	 * @return
	 */
	public int getKomaNumber_b(int d, int p){
	
		if(b_fu.exist(d, p)){
			return Resources.KomaNum_FU;
		}
		if(b_to.exist(d, p)){
			return Resources.KomaNum_TO;
		}
		if(b_kyo.exist(d, p)){
			return Resources.KomaNum_KYO;
		}
		if(b_narikyo.exist(d, p)){
			return Resources.KomaNum_NARIKYO;
		}
		
		if(b_kei.exist(d, p)){
			return Resources.KomaNum_KEI;
		}
		if(b_narikei.exist(d, p)){
			return Resources.KomaNum_NARIKEI;
		}
		if(b_gin.exist(d, p)){
			return Resources.KomaNum_GIN;
		}
		if(b_narigin.exist(d, p)){
			return Resources.KomaNum_NARIGIN;
		}
		
		if(b_kin.exist(d, p)){
			return Resources.KomaNum_KIN;
		}
		if(b_kaku.exist(d, p)){
			return Resources.KomaNum_KAKU;
		}
		if(b_uma.exist(d, p)){
			return Resources.KomaNum_UMA;
		}
		if(b_hisha.exist(d, p)){
			return Resources.KomaNum_HISHA;
		}
		if(b_ryu.exist(d, p)){
			return Resources.KomaNum_RYU;
		}
		if(b_ou.exist(d, p)){
			return Resources.KomaNum_OU;
		}
		return -1;
	}
	
	public int getKomaNumber_w(int d, int p){
		
		if(w_fu.exist(d, p)){
			return Resources.KomaNum_FU;
		}
		if(w_to.exist(d, p)){
			return Resources.KomaNum_TO;
		}
		if(w_kyo.exist(d, p)){
			return Resources.KomaNum_KYO;
		}
		if(w_narikyo.exist(d, p)){
			return Resources.KomaNum_NARIKYO;
		}
		
		if(w_kei.exist(d, p)){
			return Resources.KomaNum_KEI;
		}
		if(w_narikei.exist(d, p)){
			return Resources.KomaNum_NARIKEI;
		}
		if(w_gin.exist(d, p)){
			return Resources.KomaNum_GIN;
		}
		if(w_narigin.exist(d, p)){
			return Resources.KomaNum_NARIGIN;
		}
		
		if(w_kin.exist(d, p)){
			return Resources.KomaNum_KIN;
		}
		if(w_kaku.exist(d, p)){
			return Resources.KomaNum_KAKU;
		}
		if(w_uma.exist(d, p)){
			return Resources.KomaNum_UMA;
		}
		if(w_hisha.exist(d, p)){
			return Resources.KomaNum_HISHA;
		}
		if(w_ryu.exist(d, p)){
			return Resources.KomaNum_RYU;
		}
		if(w_ou.exist(d, p)){
			return Resources.KomaNum_OU;
		}
		return -1;
	}
	
	/**
	 * ̒n_ɃR}݂邩`FbNB
	 * ݂炻̃R}AȂnullԂB
	 * @param d@ue 0, mid 1, sita 2
	 * @param p `FbNrbgʒu
	 * @return
	 */
	public EachKoma checkExist_w(int d, int p){
		if(w_fu.exist(d, p)){
			return w_fu;
		}
		if(w_kyo.exist(d, p)){
			return w_kyo;
		}
		if(w_kei.exist(d, p)){
			return w_kei;
		}
		if(w_gin.exist(d, p)){
			return w_gin;
		}
		if(w_kin.exist(d, p)){
			return w_kin;
		}
		if(w_kaku.exist(d, p)){
			return w_kaku;
		}
		if(w_hisha.exist(d, p)){
			return w_hisha;
		}
		if(w_ou.exist(d, p)){
			return w_ou;
		}
		if(w_to.exist(d, p)){
			return w_to;
		}
		if(w_narikyo.exist(d, p)){
			return w_narikyo;
		}
		if(w_narikei.exist(d, p)){
			return w_narikei;
		}
		if(w_narigin.exist(d, p)){
			return w_narigin;
		}
		if(w_uma.exist(d, p)){
			return w_uma;
		}
		if(w_ryu.exist(d, p)){
			return w_ryu;
		}
		
		return null;
	}
	
	public void init(){
		{
			b_fu.sita = (1 << 9) - 1;
			b_fu.sita = b_fu.sita << 18;;
		}
		{
			w_fu.ue = (1 << 9) - 1;
		}
		{
			b_kyo.sita = 1 << 8;
			b_kyo.sita |= 1;
		}
		{
			w_kyo.ue = 1 << 8;
			w_kyo.ue |= 1;
			w_kyo.ue = w_kyo.ue << 18;
		}
		{
			b_kei.sita = 1 << 7;
			b_kei.sita |= 1 << 1;
		}
		{
			w_kei.ue = 1 << 7;
			w_kei.ue |= 1 << 1;
			w_kei.ue = w_kei.ue << 18;
		}
		{
			b_gin.sita = 1 << 6;
			b_gin.sita |= 1 << 2;
		}
		{
			w_gin.ue = 1 << 6;
			w_gin.ue |= 1 << 2;
			w_gin.ue = w_gin.ue << 18;
		}
		{
			b_kin.sita = 1 << 5;
			b_kin.sita |= 1 << 3;
		}
		{
			w_kin.ue = 1 << 5;
			w_kin.ue |= 1 << 3;
			w_kin.ue = w_kin.ue << 18;
		}
		{
			b_kaku.sita = 1 << 7;
			b_kaku.sita = b_kaku.sita << 9;
		}
		{
			w_kaku.ue = 1 << 1;
			w_kaku.ue = w_kaku.ue << 9;
		}
		{
			b_hisha.sita = 1 << 1;
			b_hisha.sita = b_hisha.sita << 9;
		}
		{
			w_hisha.ue = 1 << 7;
			w_hisha.ue = w_hisha.ue << 9;
		}
		{
			b_hisha.sita = 1 << 1;
			b_hisha.sita = b_hisha.sita << 9;
		}
		{
			w_hisha.ue = 1 << 7;
			w_hisha.ue = w_hisha.ue << 9;
		}
		
		{
			b_ou.sita = 1 << 4;
		}
		{
			w_ou.ue = 1 << 4;
			w_ou.ue = w_ou.ue << 18;
		}
		
		updAllKoma();
	}
	
	

	
	public int tensuu(){
		int r = 0;
		r += (b_fu.num() - w_fu.num()) * Resources.Fu_ban;
		r += (b_to.num() - w_to.num()) * Resources.To_ban;
		r += (b_kyo.num() - w_kyo.num()) * Resources.Kyo_ban;
		r += (b_narikyo.num() - w_narikyo.num()) * Resources.NariKyo_ban;
		r += (b_kei.num() - w_kei.num()) * Resources.Kei_ban;
		r += (b_narikei.num() - w_narikei.num()) * Resources.NariKei_ban;
		r += (b_gin.num() - w_gin.num()) * Resources.Gin_ban;
		r += (b_narigin.num() - w_narigin.num()) * Resources.NariGin_ban;
		r += (b_kin.num() - w_kin.num()) * Resources.Kin_ban;
		r += (b_kaku.num() - w_kaku.num()) * Resources.Kaku_ban;
		r += (b_uma.num() - w_uma.num()) * Resources.Uma_ban;
		r += (b_hisha.num() - w_hisha.num()) * Resources.Hisha_ban;
		r += (b_ryu.num() - w_ryu.num()) * Resources.Ryu_ban;
		r += (getFuNum_b() - getFuNum_w()) * Resources.Fu_tegoma;
		r += (getKyoNum_b() - getKyoNum_w()) * Resources.Kyo_tegoma;
		r += (getKeiNum_b() - getKeiNum_w()) * Resources.Kei_tegoma;
		r += (getGinNum_b() - getGinNum_w()) * Resources.Gin_tegoma;
		r += (getKinNum_b() - getKinNum_w()) * Resources.Kin_tegoma;
		r += (getKakuNum_b() - getKakuNum_w()) * Resources.Kaku_tegoma;
		r += (getHishaNum_b() - getHishaNum_w()) * Resources.Hisha_tegoma;
		return r;
	}
	
//	/**
//	 * USIR}h̓B
//	 * R}ĥ͎݂Ȃ̂ŏXĂvB
//	 * @param s
//	 */
//	public void usimove(String s, boolean b) throws Exception{
//		if(s.charAt(1) == '*'){
//			// ł
//			
//			int afY = s.charAt(2) - '0';
//			int afT = s.charAt(3) - 'a' + 1;
//			char koma = s.charAt(0);
//			if(koma == 'P'){ // 
//				if(b){
//					b_fu.addSD(afY, afT);
//					delFu_b();
//				}
//				else{
//					w_fu.addSD(afY, afT);
//					delFu_w();
//				}
//			}
//			else if(koma == 'L'){
//				if(b){
//					b_kyo.addSD(afY, afT);
//					delKyo_b();
//				}
//				else{
//					w_kyo.addSD(afY, afT);
//					delKyo_w();
//				}
//			}
//			else if(koma == 'N'){
//				if(b){
//					b_kei.addSD(afY, afT);
//					delKei_b();
//				}
//				else{
//					w_kei.addSD(afY, afT);
//					delKei_w();
//				}
//			}
//			else if(koma == 'S'){
//				if(b){
//					b_gin.addSD(afY, afT);
//					delGin_b();
//				}
//				else{
//					w_gin.addSD(afY, afT);
//					delGin_w();
//				}
//			}
//			else if(koma == 'G'){
//				if(b){
//					b_kin.addSD(afY, afT);
//					delKin_b();
//				}
//				else{
//					w_kin.addSD(afY, afT);
//					delKin_w();
//				}
//			}
//			else if(koma == 'B'){
//				if(b){
//					b_kaku.addSD(afY, afT);
//					delKaku_b();
//				}
//				else{
//					w_kaku.addSD(afY, afT);
//					delKaku_w();
//				}
//			}
//			else if(koma == 'R'){
//				if(b){
//					b_hisha.addSD(afY, afT);
//					delHisha_b();
//				}
//				else{
//					w_hisha.addSD(afY, afT);
//					delHisha_w();
//				}
//			}
//			
//		}
//		else{
//			int bfY = s.charAt(0) - '0';
//			int bfT = s.charAt(1) - 'a' + 1;
//			int afY = s.charAt(2) - '0';
//			int afT = s.charAt(3) - 'a' + 1;
//			boolean nari = false;
//			if(s.length() == 5 && s.charAt(4) == '+'){
//				nari = true;
//			}
//			EachKoma bfk = null;
//			EachKoma afk = null;
//			boolean debug = false;
//			
//			if(b_fu.existCheckSujiDan(bfY, bfT)){
//				bfk = b_fu;
//				afk = b_fu;
//				if(nari){
//					afk = b_to;
//				}
//				debug = true;
//			}
//			else if(b_kyo.existCheckSujiDan(bfY, bfT)){
//				bfk = b_kyo;
//				afk = b_kyo;
//				if(nari){
//					afk = b_narikyo;
//				}
//				debug = true;
//			}
//			else if(b_kei.existCheckSujiDan(bfY, bfT)){
//				bfk = b_kei;
//				afk = b_kei;
//				if(nari){
//					afk = b_narikei;
//				}
//				debug = true;
//			}
//			else if(b_gin.existCheckSujiDan(bfY, bfT)){
//				bfk = b_gin;
//				afk = b_gin;
//				if(nari){
//					afk = b_narigin;
//				}
//				debug = true;
//			}
//			else if(b_kin.existCheckSujiDan(bfY, bfT)){
//				bfk = b_kin;
//				afk = b_kin;
//				debug = true;
//			}
//			else if(b_kaku.existCheckSujiDan(bfY, bfT)){
//				bfk = b_kaku;
//				afk = b_kaku;
//				if(nari){
//					afk = b_uma;
//				}
//				debug = true;
//			}
//			else if(b_hisha.existCheckSujiDan(bfY, bfT)){
//				bfk = b_hisha;
//				afk = b_hisha;
//				if(nari){
//					afk = b_ryu;
//				}
//				debug = true;
//			}
//			else if(b_ou.existCheckSujiDan(bfY, bfT)){
//				bfk = b_ou;
//				afk = b_ou;
//				debug = true;
//			}
//			else if(b_to.existCheckSujiDan(bfY, bfT)){
//				bfk = b_to;
//				afk = b_to;
//				debug = true;
//			}
//			else if(b_narikyo.existCheckSujiDan(bfY, bfT)){
//				bfk = b_narikyo;
//				afk = b_narikyo;
//				debug = true;
//			}
//			else if(b_narikei.existCheckSujiDan(bfY, bfT)){
//				bfk = b_narikei;
//				afk = b_narikei;
//				debug = true;
//			}
//			else if(b_narigin.existCheckSujiDan(bfY, bfT)){
//				bfk = b_narigin;
//				afk = b_narigin;
//				debug = true;
//			}
//			else if(b_uma.existCheckSujiDan(bfY, bfT)){
//				bfk = b_uma;
//				afk = b_uma;
//				debug = true;
//			}
//			else if(b_ryu.existCheckSujiDan(bfY, bfT)){
//				bfk = b_ryu;
//				afk = b_ryu;
//				debug = true;
//			}
//			else if(w_fu.existCheckSujiDan(bfY, bfT)){
//				bfk = w_fu;
//				afk = w_fu;
//				if(nari){
//					afk = w_to;
//				}
//				debug = true;
//			}
//			else if(w_kyo.existCheckSujiDan(bfY, bfT)){
//				bfk = w_kyo;
//				afk = w_kyo;
//				if(nari){
//					afk = w_narikyo;
//				}
//				debug = true;
//			}
//			else if(w_kei.existCheckSujiDan(bfY, bfT)){
//				bfk = w_kei;
//				afk = w_kei;
//				if(nari){
//					afk = w_narikei;
//				}
//				debug = true;
//			}
//			else if(w_gin.existCheckSujiDan(bfY, bfT)){
//				bfk = w_gin;
//				afk = w_gin;
//				if(nari){
//					afk = w_narigin;
//				}
//				debug = true;
//			}
//			else if(w_kin.existCheckSujiDan(bfY, bfT)){
//				bfk = w_kin;
//				afk = w_kin;
//				debug = true;
//			}
//			else if(w_kaku.existCheckSujiDan(bfY, bfT)){
//				bfk = w_kaku;
//				afk = w_kaku;
//				if(nari){
//					afk = w_uma;
//				}
//				debug = true;
//			}
//			else if(w_hisha.existCheckSujiDan(bfY, bfT)){
//				bfk = w_hisha;
//				afk = w_hisha;
//				if(nari){
//					afk = w_ryu;
//				}
//				debug = true;
//			}
//			else if(w_ou.existCheckSujiDan(bfY, bfT)){
//				bfk = w_ou;
//				afk = w_ou;
//				debug = true;
//			}
//			else if(w_to.existCheckSujiDan(bfY, bfT)){
//				bfk = w_to;
//				afk = w_to;
//				debug = true;
//			}
//			else if(w_narikyo.existCheckSujiDan(bfY, bfT)){
//				bfk = w_narikyo;
//				afk = w_narikyo;
//				debug = true;
//			}
//			else if(w_narikei.existCheckSujiDan(bfY, bfT)){
//				bfk = w_narikei;
//				afk = w_narikei;
//				debug = true;
//			}
//			else if(w_narigin.existCheckSujiDan(bfY, bfT)){
//				bfk = w_narigin;
//				afk = w_narigin;
//				debug = true;
//			}
//			else if(w_uma.existCheckSujiDan(bfY, bfT)){
//				bfk = w_uma;
//				afk = w_uma;
//				debug = true;
//			}
//			else if(w_ryu.existCheckSujiDan(bfY, bfT)){
//				bfk = w_ryu;
//				afk = w_ryu;
//				debug = true;
//			}
//			bfk.delSD(bfY, bfT);
//			afk.addSD(afY, afT);
//			if(b){
//				if(w_fu.existCheckSujiDan(afY, afT)){
//					w_fu.delSD(afY, afT);
//					addFu_b();
//				}
//				else if(w_to.existCheckSujiDan(afY, afT)){
//					w_to.delSD(afY, afT);
//					addFu_b();
//				}
//				else if(w_kyo.existCheckSujiDan(afY, afT)){
//					w_kyo.delSD(afY, afT);
//					addKyo_b();
//				}
//				else if(w_narikyo.existCheckSujiDan(afY, afT)){
//					w_narikyo.delSD(afY, afT);
//					addKyo_b();
//				}
//				else if(w_kei.existCheckSujiDan(afY, afT)){
//					w_kei.delSD(afY, afT);
//					addKei_b();
//				}
//				else if(w_narikei.existCheckSujiDan(afY, afT)){
//					w_narikei.delSD(afY, afT);
//					addKei_b();
//				}
//				else if(w_gin.existCheckSujiDan(afY, afT)){
//					w_gin.delSD(afY, afT);
//					addGin_b();
//				}
//				else if(w_narigin.existCheckSujiDan(afY, afT)){
//					w_narigin.delSD(afY, afT);
//					addGin_b();
//				}
//				else if(w_kin.existCheckSujiDan(afY, afT)){
//					w_kin.delSD(afY, afT);
//					addKin_b();
//				}
//				else if(w_kaku.existCheckSujiDan(afY, afT)){
//					w_kaku.delSD(afY, afT);
//					addKaku_b();
//				}
//				else if(w_uma.existCheckSujiDan(afY, afT)){
//					w_uma.delSD(afY, afT);
//					addKaku_b();
//				}
//				else if(w_hisha.existCheckSujiDan(afY, afT)){
//					w_hisha.delSD(afY, afT);
//					addHisha_b();
//				}
//				else if(w_ryu.existCheckSujiDan(afY, afT)){
//					w_ryu.delSD(afY, afT);
//					addHisha_b();
//				}
//			}
//			else{
//				if(b_fu.existCheckSujiDan(afY, afT)){
//					b_fu.delSD(afY, afT);
//					addFu_w();
//				}
//				else if(b_to.existCheckSujiDan(afY, afT)){
//					b_to.delSD(afY, afT);
//					addFu_w();
//				}
//				else if(b_kyo.existCheckSujiDan(afY, afT)){
//					b_kyo.delSD(afY, afT);
//					addKyo_w();
//				}
//				else if(b_narikyo.existCheckSujiDan(afY, afT)){
//					b_narikyo.delSD(afY, afT);
//					addKyo_w();
//				}
//				else if(b_kei.existCheckSujiDan(afY, afT)){
//					b_kei.delSD(afY, afT);
//					addKei_w();
//				}
//				else if(b_narikei.existCheckSujiDan(afY, afT)){
//					b_narikei.delSD(afY, afT);
//					addKei_w();
//				}
//				else if(b_gin.existCheckSujiDan(afY, afT)){
//					b_gin.delSD(afY, afT);
//					addGin_w();
//				}
//				else if(b_narigin.existCheckSujiDan(afY, afT)){
//					b_narigin.delSD(afY, afT);
//					addGin_w();
//				}
//				else if(b_kin.existCheckSujiDan(afY, afT)){
//					b_kin.delSD(afY, afT);
//					addKin_w();
//				}
//				else if(b_kaku.existCheckSujiDan(afY, afT)){
//					b_kaku.delSD(afY, afT);
//					addKaku_w();
//				}
//				else if(b_uma.existCheckSujiDan(afY, afT)){
//					b_uma.delSD(afY, afT);
//					addKaku_w();
//				}
//				else if(b_hisha.existCheckSujiDan(afY, afT)){
//					b_hisha.delSD(afY, afT);
//					addHisha_w();
//				}
//				else if(b_ryu.existCheckSujiDan(afY, afT)){
//					b_ryu.delSD(afY, afT);
//					addHisha_w();
//				}
//			}
//		}
//		updAllKoma();
//		updateHyoka();
//	}
	
	public final void addTegoma_b(int koma){
		if(koma == Resources.KomaNum_FU){
			addFu_b();
		}
		else if(koma == Resources.KomaNum_KYO){
			addKyo_b();
		}
		else if(koma == Resources.KomaNum_KEI){
			addKei_b();
		}
		else if(koma == Resources.KomaNum_GIN){
			addGin_b();
		}
		else if(koma == Resources.KomaNum_KIN){
			addKin_b();
		}
		else if(koma == Resources.KomaNum_KAKU){
			addKaku_b();
		}
		else if(koma == Resources.KomaNum_HISHA){
			addHisha_b();
		}
		else if(koma == Resources.KomaNum_OU){
			addOu_b();
		}
		
	}
	
	public final void addTegoma_w(int koma){
		if(koma == Resources.KomaNum_FU){
			addFu_w();
		}
		else if(koma == Resources.KomaNum_KYO){
			addKyo_w();
		}
		else if(koma == Resources.KomaNum_KEI){
			addKei_w();
		}
		else if(koma == Resources.KomaNum_GIN){
			addGin_w();
		}
		else if(koma == Resources.KomaNum_KIN){
			addKin_w();
		}
		else if(koma == Resources.KomaNum_KAKU){
			addKaku_w();
		}
		else if(koma == Resources.KomaNum_HISHA){
			addHisha_w();
		}
		else if(koma == Resources.KomaNum_OU){
			addOu_w();
		}
	}
	
	
	// 1-5 
	// 6-8 
	// 9-11 j
	// 12-14 
	// 15-17 
	// 18-19 p
	// 20-21 
	private static final int fumask = (1 << 5) - 1;
	private static final int fourMask = (1 << 3) - 1;
	private static final int twoMask = (1 << 2) - 1;
	
	private static final int OU = 1 << 21;
	
	public void addOu_b(){
		b_tegoma |= OU;
	}
	
	public boolean isOu_b(){
		return (b_tegoma & OU) > 0;
	}
	
	public void addOu_w(){
		w_tegoma |= OU;
	}
	
	public boolean isOu_w(){
		return (w_tegoma & OU) > 0;
	}
	
	private void updFu_b(int n){
		int b = (1 << 21) - 1;
		b ^= fumask;
		b_tegoma &= b;
		b_tegoma |= n;
	}
	private void updKyo_b(int n){
		int b = (1 << 21) - 1;
		b ^= (fourMask << 5);
		b_tegoma &= b;
		b_tegoma |= (n << 5);
	}
	private void updKei_b(int n){
		int b = (1 << 21) - 1;
		b ^= (fourMask << 8);
		b_tegoma &= b;
		b_tegoma |= (n << 8);
	}
	private void updGin_b(int n){
		int b = (1 << 21) - 1;
		b ^= (fourMask << 11);
		b_tegoma &= b;
		b_tegoma |= (n << 11);
	}
	private void updKin_b(int n){
		int b = (1 << 21) - 1;
		b ^= (fourMask << 14);
		b_tegoma &= b;
		b_tegoma |= (n << 14);
	}
	private void updKaku_b(int n){
		int b = (1 << 21) - 1;
		b ^= (twoMask << 17);
		b_tegoma &= b;
		b_tegoma |= (n << 17);
	}
	private void updHisha_b(int n){
		int b = (1 << 21) - 1;
		b ^= (twoMask << 19);
		b_tegoma &= b;
		b_tegoma |= (n << 19);
	}
	
	public void delFu_b(){
		int n = getFuNum_b();
		n--;
		updFu_b(n);
	}
	public void addFu_b(){
		int n = getFuNum_b();
		n++;
		updFu_b(n);
	}
	public void delKyo_b(){
		int n = getKyoNum_b();
		n--;
		updKyo_b(n);
	}
	public void addKyo_b(){
		int n = getKyoNum_b();
		n++;
		updKyo_b(n);
	}
	public void delKei_b(){
		int n = getKeiNum_b();
		n--;
		updKei_b(n);
	}
	public void addKei_b(){
		int n = getKeiNum_b();
		n++;
		updKei_b(n);
	}
	public void delGin_b(){
		int n = getGinNum_b();
		n--;
		updGin_b(n);
	}
	public void addGin_b(){
		int n = getGinNum_b();
		n++;
		updGin_b(n);
	}
	public void delKin_b(){
		int n = getKinNum_b();
		n--;
		updKin_b(n);
	}
	public void addKin_b(){
		int n = getKinNum_b();
		n++;
		updKin_b(n);
	}
	public void delKaku_b(){
		int n = getKakuNum_b();
		n--;
		updKaku_b(n);
	}
	public void addKaku_b(){
		int n = getKakuNum_b();
		n++;
		updKaku_b(n);
	}
	public void delHisha_b(){
		int n = getHishaNum_b();
		n--;
		updHisha_b(n);
	}
	public void addHisha_b(){
		int n = getHishaNum_b();
		n++;
		updHisha_b(n);
	}
	
	private void updFu_w(int n){
		int b = (1 << 21) - 1;
		b ^= fumask;
		w_tegoma &= b;
		w_tegoma |= n;
	}
	private void updKyo_w(int n){
		int b = (1 << 21) - 1;
		b ^= (fourMask << 5);
		w_tegoma &= b;
		w_tegoma |= (n << 5);
	}
	private void updKei_w(int n){
		int b = (1 << 21) - 1;
		b ^= (fourMask << 8);
		w_tegoma &= b;
		w_tegoma |= (n << 8);
	}
	private void updGin_w(int n){
		int b = (1 << 21) - 1;
		b ^= (fourMask << 11);
		w_tegoma &= b;
		w_tegoma |= (n << 11);
	}
	private void updKin_w(int n){
		int b = (1 << 21) - 1;
		b ^= (fourMask << 14);
		w_tegoma &= b;
		w_tegoma |= (n << 14);
	}
	private void updKaku_w(int n){
		int b = (1 << 21) - 1;
		b ^= (twoMask << 17);
		w_tegoma &= b;
		w_tegoma |= (n << 17);
	}
	private void updHisha_w(int n){
		int b = (1 << 21) - 1;
		b ^= (twoMask << 19);
		w_tegoma &= b;
		w_tegoma |= (n << 19);
	}
	
	public void delFu_w(){
		int n = getFuNum_w();
		n--;
		updFu_w(n);
	}
	public void addFu_w(){
		int n = getFuNum_w();
		n++;
		updFu_w(n);
	}
	public void delKyo_w(){
		int n = getKyoNum_w();
		n--;
		updKyo_w(n);
	}
	public void addKyo_w(){
		int n = getKyoNum_w();
		n++;
		updKyo_w(n);
	}
	public void delKei_w(){
		int n = getKeiNum_w();
		n--;
		updKei_w(n);
	}
	public void addKei_w(){
		int n = getKeiNum_w();
		n++;
		updKei_w(n);
	}
	public void delGin_w(){
		int n = getGinNum_w();
		n--;
		updGin_w(n);
	}
	public void addGin_w(){
		int n = getGinNum_w();
		n++;
		updGin_w(n);
	}
	public void delKin_w(){
		int n = getKinNum_w();
		n--;
		updKin_w(n);
	}
	public void addKin_w(){
		int n = getKinNum_w();
		n++;
		updKin_w(n);
	}
	public void delKaku_w(){
		int n = getKakuNum_w();
		n--;
		updKaku_w(n);
	}
	public void addKaku_w(){
		int n = getKakuNum_w();
		n++;
		updKaku_w(n);
	}
	public void delHisha_w(){
		int n = getHishaNum_w();
		n--;
		updHisha_w(n);
	}
	public void addHisha_w(){
		int n = getHishaNum_w();
		n++;
		updHisha_w(n);
	}
	
	
	
	
	public int getFuNum_b(){
		return b_tegoma & fumask;
	}
	public int getKyoNum_b(){
		return (b_tegoma >> 5) & fourMask;
	}
	public int getKeiNum_b(){
		return (b_tegoma >> 8) & fourMask;
	}
	public int getGinNum_b(){
		return (b_tegoma >> 11) & fourMask;
	}
	public int getKinNum_b(){
		return (b_tegoma >> 14) & fourMask;
	}

	public int getKakuNum_b(){
		return (b_tegoma >> 17) & twoMask;
	}
	public int getHishaNum_b(){
		return (b_tegoma >> 19) & twoMask;
	}
	public int getFuNum_w(){
		return w_tegoma & fumask;
	}
	public int getKyoNum_w(){
		return (w_tegoma >> 5) & fourMask;
	}
	public int getKeiNum_w(){
		return (w_tegoma >> 8) & fourMask;
	}
	public int getGinNum_w(){
		return (w_tegoma >> 11) & fourMask;
	}
	public int getKinNum_w(){
		return (w_tegoma >> 14) & fourMask;
	}

	public int getKakuNum_w(){
		return (w_tegoma >> 17) & twoMask;
	}
	public int getHishaNum_w(){
		return (w_tegoma >> 19) & twoMask;
	}
}
