package com.rogerfgm;

import java.util.*;

public class Bitop {
	
	public static final int KOMAIDX_UE = 0;
	public static final int KOMAIDX_MID = 1;
	public static final int KOMAIDX_SITA = 2;
	
	public static final int SanDanMe = 1 << 18;
	public static final int NiDanMe = 1 << 9;
	
	public static final int MASK = (1 << 9) - 1;
	
	public static final int LEFTONE = 1 << 8;
	public static final int LEFTTWO = 1 << 17;
	public static final int LEFTTHREE = 1 << 26;
	public static final int RIGHTONE = 1;
	public static final int RIGHTTWO = 1 << 9;
	public static final int RIGHTTHREE = 1 << 18;
	
	
	public static final int BIT_ONE = 1;
	public static final int BIT_TWO = 1 << 1;
	public static final int BIT_THREE = 1 << 2;
	public static final int BIT_FOUR = 1 << 3;
	public static final int BIT_FIVE = 1 << 4;
	public static final int BIT_SIX = 1 << 5;
	public static final int BIT_SEVEN = 1 << 6;
	public static final int BIT_EIGHT = 1 << 7;
	public static final int BIT_NINE = 1 << 8;
	
	public static final int HANTEN_ONE = 1 << 8;
	public static final int HANTEN_TWO = 1 << 7;
	public static final int HANTEN_THREE = 1 << 6;
	public static final int HANTEN_FOUR = 1 << 5;
	public static final int HANTEN_FIVE = 1 << 4;
	public static final int HANTEN_SIX = 1 << 3;
	public static final int HANTEN_SEVEN = 1 << 2;
	public static final int HANTEN_EIGHT = 1 << 1;
	public static final int HANTEN_NINE = 1;
	
	public static String sujidanUsi(int komaIdx, int p) throws Exception{
		if(p == 0){
			throw new Exception("Invalid p : 0");
		}
		int dan = 0;
		if(komaIdx == 2){
			dan = 6;
		}
		else if(komaIdx == 1){
			dan = 3;
		}
		
		
		if( (p & MASK) > 0){
			dan+= 2;
		}
		else if( ( (p >> 9) & MASK) > 0){
			dan+= 1;
			p = p >> 9;
		}
		else{
			p = p >> 18;
		}

		int suji = 0;
		for(int i = 0; i < 9; i++){
			int np = p >> i;
			if(np == 1){
				suji = i;
				break;
			}
		}
		suji++;
		char danc = 'a';
		danc += dan;
		return suji + "" + danc;
	}
	
	
//	/**
//	 * ǖʂtɂ
//	 * @param k
//	 * @return
//	 */
//	public static Kyokumen hanten(Kyokumen k){
//		Kyokumen nk = new Kyokumen();
//		nk.b_fu.ue = hanten(k.w_fu.sita);
//		nk.b_fu.mid = hanten(k.w_fu.mid);
//		nk.b_fu.sita = hanten(k.w_fu.ue);
//		nk.w_fu.ue = hanten(k.b_fu.sita);
//		nk.w_fu.mid = hanten(k.b_fu.mid);
//		nk.w_fu.sita = hanten(k.b_fu.ue);
//		
//		nk.b_to.ue = hanten(k.w_to.sita);
//		nk.b_to.mid = hanten(k.w_to.mid);
//		nk.b_to.sita = hanten(k.w_to.ue);
//		nk.w_to.ue = hanten(k.b_to.sita);
//		nk.w_to.mid = hanten(k.b_to.mid);
//		nk.w_to.sita = hanten(k.b_to.ue);
//		
//		nk.b_kyo.ue = hanten(k.w_kyo.sita);
//		nk.b_kyo.mid = hanten(k.w_kyo.mid);
//		nk.b_kyo.sita = hanten(k.w_kyo.ue);
//		nk.w_kyo.ue = hanten(k.b_kyo.sita);
//		nk.w_kyo.mid = hanten(k.b_kyo.mid);
//		nk.w_kyo.sita = hanten(k.b_kyo.ue);
//		
//		nk.b_narikyo.ue = hanten(k.w_narikyo.sita);
//		nk.b_narikyo.mid = hanten(k.w_narikyo.mid);
//		nk.b_narikyo.sita = hanten(k.w_narikyo.ue);
//		nk.w_narikyo.ue = hanten(k.b_narikyo.sita);
//		nk.w_narikyo.mid = hanten(k.b_narikyo.mid);
//		nk.w_narikyo.sita = hanten(k.b_narikyo.ue);
//		
//		nk.b_kei.ue = hanten(k.w_kei.sita);
//		nk.b_kei.mid = hanten(k.w_kei.mid);
//		nk.b_kei.sita = hanten(k.w_kei.ue);
//		nk.w_kei.ue = hanten(k.b_kei.sita);
//		nk.w_kei.mid = hanten(k.b_kei.mid);
//		nk.w_kei.sita = hanten(k.b_kei.ue);
//		
//		nk.b_narikei.ue = hanten(k.w_narikei.sita);
//		nk.b_narikei.mid = hanten(k.w_narikei.mid);
//		nk.b_narikei.sita = hanten(k.w_narikei.ue);
//		nk.w_narikei.ue = hanten(k.b_narikei.sita);
//		nk.w_narikei.mid = hanten(k.b_narikei.mid);
//		nk.w_narikei.sita = hanten(k.b_narikei.ue);
//		
//		nk.b_gin.ue = hanten(k.w_gin.sita);
//		nk.b_gin.mid = hanten(k.w_gin.mid);
//		nk.b_gin.sita = hanten(k.w_gin.ue);
//		nk.w_gin.ue = hanten(k.b_gin.sita);
//		nk.w_gin.mid = hanten(k.b_gin.mid);
//		nk.w_gin.sita = hanten(k.b_gin.ue);
//		
//		nk.b_narigin.ue = hanten(k.w_narigin.sita);
//		nk.b_narigin.mid = hanten(k.w_narigin.mid);
//		nk.b_narigin.sita = hanten(k.w_narigin.ue);
//		nk.w_narigin.ue = hanten(k.b_narigin.sita);
//		nk.w_narigin.mid = hanten(k.b_narigin.mid);
//		nk.w_narigin.sita = hanten(k.b_narigin.ue);
//		
//		nk.b_kin.ue = hanten(k.w_kin.sita);
//		nk.b_kin.mid = hanten(k.w_kin.mid);
//		nk.b_kin.sita = hanten(k.w_kin.ue);
//		nk.w_kin.ue = hanten(k.b_kin.sita);
//		nk.w_kin.mid = hanten(k.b_kin.mid);
//		nk.w_kin.sita = hanten(k.b_kin.ue);
//		
//		nk.b_kaku.ue = hanten(k.w_kaku.sita);
//		nk.b_kaku.mid = hanten(k.w_kaku.mid);
//		nk.b_kaku.sita = hanten(k.w_kaku.ue);
//		nk.w_kaku.ue = hanten(k.b_kaku.sita);
//		nk.w_kaku.mid = hanten(k.b_kaku.mid);
//		nk.w_kaku.sita = hanten(k.b_kaku.ue);
//		
//		
//		nk.b_uma.ue = hanten(k.w_uma.sita);
//		nk.b_uma.mid = hanten(k.w_uma.mid);
//		nk.b_uma.sita = hanten(k.w_uma.ue);
//		nk.w_uma.ue = hanten(k.b_uma.sita);
//		nk.w_uma.mid = hanten(k.b_uma.mid);
//		nk.w_uma.sita = hanten(k.b_uma.ue);
//		
//		nk.b_hisha.ue = hanten(k.w_hisha.sita);
//		nk.b_hisha.mid = hanten(k.w_hisha.mid);
//		nk.b_hisha.sita = hanten(k.w_hisha.ue);
//		nk.w_hisha.ue = hanten(k.b_hisha.sita);
//		nk.w_hisha.mid = hanten(k.b_hisha.mid);
//		nk.w_hisha.sita = hanten(k.b_hisha.ue);
//		
//		nk.b_ryu.ue = hanten(k.w_ryu.sita);
//		nk.b_ryu.mid = hanten(k.w_ryu.mid);
//		nk.b_ryu.sita = hanten(k.w_ryu.ue);
//		nk.w_ryu.ue = hanten(k.b_ryu.sita);
//		nk.w_ryu.mid = hanten(k.b_ryu.mid);
//		nk.w_ryu.sita = hanten(k.b_ryu.ue);
//		
//		nk.b_ou.ue = hanten(k.w_ou.sita);
//		nk.b_ou.mid = hanten(k.w_ou.mid);
//		nk.b_ou.sita = hanten(k.w_ou.ue);
//		nk.w_ou.ue = hanten(k.b_ou.sita);
//		nk.w_ou.mid = hanten(k.b_ou.mid);
//		nk.w_ou.sita = hanten(k.b_ou.ue);
//		
//		nk.b_tegoma = k.w_tegoma;
//		nk.w_tegoma = k.b_tegoma;
//		nk.hyouka = - k.hyouka;
//		
//		nk.updAllKoma();
//		
//		return nk;
//	}
//	
//	/**
//	 * tbitɂB
//	 * @param b Ֆʂue, mid, sitâǂꂩ
//	 * @return
//	 */
//	public static int hanten(int b){
//		int np = 0;
//		{
//			int t = (b >> 18) & MASK;
//			int tp = 0;
//			for(int i = 0; i < 9; i++){
//				if( (t & (1 << i)) > 0){
//					tp |= 1 << (8 - i);
//				}
//			}
//			np |= tp;
//		}
//		{
//			int t = (b >> 9) & MASK;
//			int tp = 0;
//			for(int i = 0; i < 9; i++){
//				if( (t & (1 << i)) > 0){
//					tp |= 1 << (8 - i);
//				}
//			}
//			np |= tp << 9;
//		}
//		{
//			int t = b & MASK;
//			int tp = 0;
//			for(int i = 0; i < 9; i++){
//				if( (t & (1 << i)) > 0){
//					tp |= 1 << (8 - i);
//				}
//			}
//			np |= tp << 18;
//		}
//		return np;
//	}
//	
//	public static int hantenBit(int p){
//		if(p == BIT_ONE) return HANTEN_ONE;
//		if(p == BIT_TWO) return HANTEN_TWO;
//		if(p == BIT_THREE) return HANTEN_THREE;
//		if(p == BIT_FOUR) return HANTEN_FOUR;
//		if(p == BIT_FIVE) return HANTEN_FIVE;
//		if(p == BIT_SIX) return HANTEN_SIX;
//		if(p == BIT_SEVEN) return HANTEN_SEVEN;
//		if(p == BIT_EIGHT) return HANTEN_EIGHT;
//		if(p == BIT_NINE) return HANTEN_NINE;
//		
//		return 0;
//	}
//	
//	
	/**
	 * ȊÕR}̂ꏊ񋓁ijA̔͌قǁj
	 * @param k
	 * @return
	 */
	public static List<IchiInf> getUtiPoints(Kyokumen k){
		List<IchiInf> list = new ArrayList<IchiInf>();
		for(int i = 0; i < 9; i++){
			int p = 1 << i;
			if(!k.checkExist(KOMAIDX_UE, p)){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(!k.checkExist(KOMAIDX_MID, p)){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_MID;
				ichi.p = p;
				list.add(ichi);
			}
			if(!k.checkExist(KOMAIDX_SITA, p)){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_SITA;
				ichi.p = p;
				list.add(ichi);
			}
			p = p << 9;
			if(!k.checkExist(KOMAIDX_UE, p)){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(!k.checkExist(KOMAIDX_MID, p)){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_MID;
				ichi.p = p;
				list.add(ichi);
			}
			if(!k.checkExist(KOMAIDX_SITA, p)){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_SITA;
				ichi.p = p;
				list.add(ichi);
			}
			p = p << 9;
			if(!k.checkExist(KOMAIDX_UE, p)){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(!k.checkExist(KOMAIDX_MID, p)){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_MID;
				ichi.p = p;
				list.add(ichi);
			}
			if(!k.checkExist(KOMAIDX_SITA, p)){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_SITA;
				ichi.p = p;
				list.add(ichi);
			}
		}
		
		return list;
	}
	
	public static List<IchiInf> getKyoUtiPoints_b(Kyokumen k){
		List<IchiInf> list = new ArrayList<IchiInf>();
		for(int i = 0; i < 9; i++){
			int p = 1 << i;
			if(k.checkExist_b(KOMAIDX_UE, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(k.checkExist_b(KOMAIDX_MID, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(k.checkExist_b(KOMAIDX_SITA, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			p = p << 9;
			if(k.checkExist_b(KOMAIDX_UE, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(k.checkExist_b(KOMAIDX_MID, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(k.checkExist_b(KOMAIDX_SITA, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			p = p << 9;
			// ŏi͑łĂȂ
			if(k.checkExist_b(KOMAIDX_MID, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(k.checkExist_b(KOMAIDX_SITA, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
		}
		
		return list;
	}
	
	public static List<IchiInf> getKeiUtiPoints_b(Kyokumen k){
		List<IchiInf> list = new ArrayList<IchiInf>();
		for(int i = 0; i < 9; i++){
			int p = 1 << i;
			if(k.checkExist_b(KOMAIDX_UE, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(k.checkExist_b(KOMAIDX_MID, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(k.checkExist_b(KOMAIDX_SITA, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			p = p << 9;
			// UE2iڂłĂȂ
			if(k.checkExist_b(KOMAIDX_MID, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(k.checkExist_b(KOMAIDX_SITA, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			p = p << 9;
			// UE̍ŏi͑łĂȂ
			if(k.checkExist_b(KOMAIDX_MID, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
			if(k.checkExist_b(KOMAIDX_SITA, p) == null){
				IchiInf ichi = new IchiInf();
				ichi.komaIdx = KOMAIDX_UE;
				ichi.p = p;
				list.add(ichi);
			}
		}
		
		return list;
	}
	
	
	public static List<IchiInf> getFuUtiPoints_b(Kyokumen k){
		List<IchiInf> list = new ArrayList<IchiInf>();
		for(int i = 0; i < 9; i++){
			int p = 1 << i;
			boolean f = true;
			if(k.existFu_b(KOMAIDX_UE, p) || k.existFu_b(KOMAIDX_MID, p) || k.existFu_b(KOMAIDX_SITA, p)){
				f = false;
			}
			if(f){
				p = p << 9;
				if(k.existFu_b(KOMAIDX_UE, p) || k.existFu_b(KOMAIDX_MID, p) || k.existFu_b(KOMAIDX_SITA, p)){
					f = false;
				}
			}
			if(f){
				p = p << 9;
				if(k.existFu_b(KOMAIDX_UE, p) || k.existFu_b(KOMAIDX_MID, p) || k.existFu_b(KOMAIDX_SITA, p)){
					f = false;
				}
			}
			if(f){
				// ̃XWɑłĂ
				p = 1 << i;
				if(k.checkExist_b(KOMAIDX_UE, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				if(k.checkExist_b(KOMAIDX_MID, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				if(k.checkExist_b(KOMAIDX_SITA, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				p = p << 9;
				if(k.checkExist_b(KOMAIDX_UE, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				if(k.checkExist_b(KOMAIDX_MID, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				if(k.checkExist_b(KOMAIDX_SITA, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				p = p << 9;
				// ȊOiŏi͑łĂȂj
				if(k.checkExist_b(KOMAIDX_MID, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				if(k.checkExist_b(KOMAIDX_SITA, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
			}
		}
		
		return list;
	}
	
	public static final boolean bitCheck(EachKoma e, int komaIdx, int p){
		if(komaIdx == 0){
			return (e.ue & p) > 0;
		}
		else if(komaIdx == 1){
			return (e.mid & p) > 0;
		}
		else{
			return (e.sita & p) > 0;
		}
	}
	
	/**
	 * łĂʒuƂ_ōBłɍŏiAŉiɑłĂȂ悤ɂB
	 * @param k
	 * @return
	 */
	public static final EachKoma getFuUtiPoint_b(Kyokumen k){
		EachKoma fu = new EachKoma();
		for(int i = 0; i < 9; i++){
			int p = 1 << i;
			boolean f = true;
			if(k.existFu_b(KOMAIDX_UE, p) || k.existFu_b(KOMAIDX_MID, p) || k.existFu_b(KOMAIDX_SITA, p)){
				f = false;
			}
			if(f){
				p = p << 9;
				if(k.existFu_b(KOMAIDX_UE, p) || k.existFu_b(KOMAIDX_MID, p) || k.existFu_b(KOMAIDX_SITA, p)){
					f = false;
				}
			}
			if(f){
				p = p << 9;
				if(k.existFu_b(KOMAIDX_UE, p) || k.existFu_b(KOMAIDX_MID, p) || k.existFu_b(KOMAIDX_SITA, p)){
					f = false;
				}
			}
			if(f){
				p = 1 << i;
				fu.ue |= p;
				fu.mid |= p;
				fu.sita |= p; 
				p = p << 9;
				fu.ue |= p;
				fu.mid |= p;
				fu.sita |= p;
				p = p << 9;
				fu.ue |= p; // ŏi
				fu.mid |= p;
				fu.sita |= p;
			}
		}
		return fu;
	}
	
	/**
	 * łĂʒuƂ_ōBłɍŏiAŉiɑłĂȂ悤ɂB
	 * @param k
	 * @return
	 */
	public static final EachKoma getFuUtiPoint_w(Kyokumen k){
		EachKoma fu = new EachKoma();
		for(int i = 0; i < 9; i++){
			int p = 1 << i;
			boolean f = true;
			if(k.existFu_w(KOMAIDX_UE, p) || k.existFu_w(KOMAIDX_MID, p) || k.existFu_w(KOMAIDX_SITA, p)){
				f = false;
			}
			if(f){
				p = p << 9;
				if(k.existFu_w(KOMAIDX_UE, p) || k.existFu_w(KOMAIDX_MID, p) || k.existFu_w(KOMAIDX_SITA, p)){
					f = false;
				}
			}
			if(f){
				p = p << 9;
				if(k.existFu_w(KOMAIDX_UE, p) || k.existFu_w(KOMAIDX_MID, p) || k.existFu_w(KOMAIDX_SITA, p)){
					f = false;
				}
			}
			if(f){
				p = 1 << i;
				fu.ue |= p;
				fu.mid |= p;
				//fu.sita |= p; // ŉi
				p = p << 9;
				fu.ue |= p;
				fu.mid |= p;
				fu.sita |= p;
				p = p << 9;
				fu.ue |= p;
				fu.mid |= p;
				fu.sita |= p;
			}
		}
		return fu;
	}
	
	
	
	
	public static List<IchiInf> getFuUtiPoints_w(Kyokumen k){
		List<IchiInf> list = new ArrayList<IchiInf>();
		for(int i = 0; i < 9; i++){
			int p = 1 << i;
			boolean f = true;
			if(k.existFu_w(KOMAIDX_UE, p) || k.existFu_w(KOMAIDX_MID, p) || k.existFu_w(KOMAIDX_SITA, p)){
				f = false;
			}
			if(f){
				p = p << 9;
				if(k.existFu_b(KOMAIDX_UE, p) || k.existFu_b(KOMAIDX_MID, p) || k.existFu_b(KOMAIDX_SITA, p)){
					f = false;
				}
			}
			if(f){
				p = p << 9;
				if(k.existFu_b(KOMAIDX_UE, p) || k.existFu_b(KOMAIDX_MID, p) || k.existFu_b(KOMAIDX_SITA, p)){
					f = false;
				}
			}
			if(f){
				// ̃XWɑłĂ
				p = 1 << i;
				if(k.checkExist_b(KOMAIDX_UE, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				if(k.checkExist_b(KOMAIDX_MID, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				if(k.checkExist_b(KOMAIDX_SITA, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				p = p << 9;
				if(k.checkExist_b(KOMAIDX_UE, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				if(k.checkExist_b(KOMAIDX_MID, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				if(k.checkExist_b(KOMAIDX_SITA, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				p = p << 9;
				// ȊOiŏi͑łĂȂj
				if(k.checkExist_b(KOMAIDX_MID, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
				if(k.checkExist_b(KOMAIDX_SITA, p) == null){
					IchiInf ichi = new IchiInf();
					ichi.komaIdx = KOMAIDX_UE;
					ichi.p = p;
					list.add(ichi);
				}
			}
		}
		
		return list;
	}
	
	public static List<IchiInf> getRyuMovePoints_b(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = getHishaMovePoints_b(k, orgKomaIdx, p);
		
		// 
		addLeftUp_b(p, orgKomaIdx, k, list);
		
		// E
		addRightUp_b(p, orgKomaIdx, k, list);
		
		// 
		addLeftDown_b(p, orgKomaIdx, k, list);
		
		// E
		addRightDown_b(p, orgKomaIdx, k, list);

		return list;
	}
	
	public static List<IchiInf> getRyuMovePoints_w(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = getHishaMovePoints_w(k, orgKomaIdx, p);
		
		// 
		addLeftUp_w(p, orgKomaIdx, k, list);
		
		// E
		addRightUp_w(p, orgKomaIdx, k, list);
		
		// 
		addLeftDown_w(p, orgKomaIdx, k, list);
		
		// E
		addRightDown_w(p, orgKomaIdx, k, list);

		return list;
	}
	
	public static List<IchiInf> getUmaMovePoints_b(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = getKakuMovePoints_b(k, orgKomaIdx, p);
		
		// 
		addLeft_b(p, orgKomaIdx, k, list);
		
		// E
		addRight_b(p, orgKomaIdx, k, list);
		
		// 
		addDown_b(p, orgKomaIdx, k, list);
		
		// 
		addUp_b(p, orgKomaIdx, k, list);

		return list;
	}
	
	public static List<IchiInf> getUmaMovePoints_w(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = getKakuMovePoints_w(k, orgKomaIdx, p);
		
		// 
		addLeft_w(p, orgKomaIdx, k, list);
		
		// E
		addRight_w(p, orgKomaIdx, k, list);
		
		// 
		addDown_w(p, orgKomaIdx, k, list);
		
		// 
		addUp_w(p, orgKomaIdx, k, list);

		return list;
	}
	
	public static List<IchiInf> getKinMovePoints_b(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		// 
		addLeftUp_b(p, orgKomaIdx, k, list);
		
		// 
		addUp_b(p, orgKomaIdx, k, list);
		
		// E
		addRightUp_b(p, orgKomaIdx, k, list);
		
		// 
		addLeft_b(p, orgKomaIdx, k, list);
		
		// E
		addRight_b(p, orgKomaIdx, k, list);
		
		// 
		addDown_b(p, orgKomaIdx, k, list);
		
		return list;
	}
	
	public static List<IchiInf> getKinMovePoints_w(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();

		
		// 
		addUp_w(p, orgKomaIdx, k, list);
		
		// 
		addLeft_w(p, orgKomaIdx, k, list);
		
		// E
		addRight_w(p, orgKomaIdx, k, list);
		
		// 
		addDown_w(p, orgKomaIdx, k, list);
		
		// 
		addLeftDown_w(p, orgKomaIdx, k, list);
		
		// E
		addRightDown_w(p, orgKomaIdx, k, list);
		
		return list;
	}
	
	public static List<IchiInf> getOuMovePoints_b(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		// 
		addLeftUp_b(p, orgKomaIdx, k, list);
		
		// 
		addUp_b(p, orgKomaIdx, k, list);
		
		// E
		addRightUp_b(p, orgKomaIdx, k, list);
		
		// 
		addLeft_b(p, orgKomaIdx, k, list);
		
		// E
		addRight_b(p, orgKomaIdx, k, list);
		
		// 
		addLeftDown_b(p, orgKomaIdx, k, list);
		
		// 
		addDown_b(p, orgKomaIdx, k, list);
		
		// E
		addRightDown_b(p, orgKomaIdx, k, list);

		return list;
	}
	
	public static List<IchiInf> getOuMovePoints_w(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		// 
		addLeftUp_w(p, orgKomaIdx, k, list);
		
		// 
		addUp_w(p, orgKomaIdx, k, list);
		
		// E
		addRightUp_w(p, orgKomaIdx, k, list);
		
		// 
		addLeft_w(p, orgKomaIdx, k, list);
		
		// E
		addRight_w(p, orgKomaIdx, k, list);
		
		// 
		addLeftDown_w(p, orgKomaIdx, k, list);
		
		// 
		addDown_w(p, orgKomaIdx, k, list);
		
		// E
		addRightDown_w(p, orgKomaIdx, k, list);

		return list;
	}
	
	private static void addLeftUp_b(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != LEFTONE && np != LEFTTWO && np != LEFTTHREE && !(np >= SanDanMe && komaIdx == 0)){
			if(np >= SanDanMe){
				np = np >> 17;
				komaIdx--;
			}
			else{
				np = np << 10;
			}
			addAndCheckBreak_b(k, komaIdx, np, list);
		}
	}

	private static void addLeftUp_w(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != LEFTONE && np != LEFTTWO && np != LEFTTHREE && !(np >= SanDanMe && komaIdx == 0)){
			if(np >= SanDanMe){
				np = np >> 17;
				komaIdx--;
			}
			else{
				np = np << 10;
			}
			addAndCheckBreak_w(k, komaIdx, np, list);
		}
	}
	
	private static final void addRightUp_b(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != RIGHTONE && np != RIGHTTWO && np != RIGHTTHREE && !(np >= SanDanMe && komaIdx == 0)){
			if(np >= SanDanMe){
				np = np >> 19;
				komaIdx--;
			}
			else{
				np = np << 8;
			}
			addAndCheckBreak_b(k, komaIdx, np, list);
		}
	}
	
	private static final void addRightUp_w(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != RIGHTONE && np != RIGHTTWO && np != RIGHTTHREE && !(np >= SanDanMe && komaIdx == 0)){
			if(np >= SanDanMe){
				np = np >> 19;
				komaIdx--;
			}
			else{
				np = np << 8;
			}
			addAndCheckBreak_w(k, komaIdx, np, list);
		}
	}
	
	private static void addLeft_b(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != LEFTONE && np != LEFTTWO && np != LEFTTHREE ){
			np = np << 1;
			addAndCheckBreak_b(k, komaIdx, np, list);
		}
	}
	
	private static void addLeft_w(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != LEFTONE && np != LEFTTWO && np != LEFTTHREE ){
			np = np << 1;
			addAndCheckBreak_w(k, komaIdx, np, list);
		}
	}
	
	private static void addRight_b(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != RIGHTONE && np != RIGHTTWO && np != RIGHTTHREE ){
			np = np >> 1;
			addAndCheckBreak_b(k, komaIdx, np, list);
		}
	}
	
	private static void addRight_w(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != RIGHTONE && np != RIGHTTWO && np != RIGHTTHREE ){
			np = np >> 1;
			addAndCheckBreak_w(k, komaIdx, np, list);
		}
	}
	
	private static void addUp_b(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(!(np >= SanDanMe && komaIdx == 0)){
			if(np >= SanDanMe){
				np = np >> 18;
				komaIdx--;
			}
			else{
				np = np << 9;
			}
			addAndCheckBreak_b(k, komaIdx, np, list);
		}
	}
	
	private static void addUp_w(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(!(np >= SanDanMe && komaIdx == 0)){
			if(np >= SanDanMe){
				np = np >> 18;
				komaIdx--;
			}
			else{
				np = np << 9;
			}
			addAndCheckBreak_w(k, komaIdx, np, list);
		}
	}
	
	private static void addDown_b(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(!(np < NiDanMe && komaIdx == 2)){
			if(np < NiDanMe){
				np = np << 18;
				komaIdx++;
			}
			else{
				np = np >> 9;
			}
			addAndCheckBreak_b(k, komaIdx, np, list);
		}
	}
	
	private static void addDown_w(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(!(np < NiDanMe && komaIdx == 2)){
			if(np < NiDanMe){
				np = np << 18;
				komaIdx++;
			}
			else{
				np = np >> 9;
			}
			addAndCheckBreak_w(k, komaIdx, np, list);
		}
	}
	
	private static void addLeftDown_b(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != LEFTONE && np != LEFTTWO && np != LEFTTHREE && !(np < NiDanMe && komaIdx == 2)){
			if(np < NiDanMe){
				np = np << 19;
				komaIdx++;
			}
			else{
				np = np >> 8;
			}
			addAndCheckBreak_b(k, komaIdx, np, list);
		}
	}
	
	private static void addLeftDown_w(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != LEFTONE && np != LEFTTWO && np != LEFTTHREE && !(np < NiDanMe && komaIdx == 2)){
			if(np < NiDanMe){
				np = np << 19;
				komaIdx++;
			}
			else{
				np = np >> 8;
			}
			addAndCheckBreak_w(k, komaIdx, np, list);
		}
	}
	
	private static void addRightDown_b(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != RIGHTONE && np != RIGHTTWO && np != RIGHTTHREE && !(np < NiDanMe && komaIdx == 2)){
			if(np < NiDanMe){
				np = np << 17;
				komaIdx++;
			}
			else{
				np = np >> 10;
			}
			addAndCheckBreak_b(k, komaIdx, np, list);
		}
	}
	
	private static void addRightDown_w(int p, int orgKomaIdx, Kyokumen k, List<IchiInf> list){
		int np = p;
		int komaIdx = orgKomaIdx;
		if(np != RIGHTONE && np != RIGHTTWO && np != RIGHTTHREE && !(np < NiDanMe && komaIdx == 2)){
			if(np < NiDanMe){
				np = np << 17;
				komaIdx++;
			}
			else{
				np = np >> 10;
			}
			addAndCheckBreak_w(k, komaIdx, np, list);
		}
	}
	
	public static List<IchiInf> getHishaMovePoints_b(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		// 
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == LEFTONE || np == LEFTTWO || np == LEFTTHREE){
					break;
				}
				np = np << 1;
				
				if(addAndCheckBreak_b(k, komaIdx, np, list)){
					break;
				}
			}
		}
		
		// E
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == RIGHTONE || np == RIGHTTWO || np == RIGHTTHREE){
					break;
				}
				np = np >> 1;
				
				if(addAndCheckBreak_b(k, komaIdx, np, list)){
					break;
				}
			}
		}
		
		// 
		{
			// Ƌʂ̂
			getUpMovePoints_b(k, orgKomaIdx, p, list);
		}
		
		// 
		{
			getDownMovePoints_b(k, orgKomaIdx, p, list);
		}
		return list;
	}
	
	public static List<IchiInf> getHishaMovePoints_w(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		// 
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == LEFTONE || np == LEFTTWO || np == LEFTTHREE){
					break;
				}
				np = np << 1;
				
				if(addAndCheckBreak_w(k, komaIdx, np, list)){
					break;
				}
			}
		}
		
		// E
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == RIGHTONE || np == RIGHTTWO || np == RIGHTTHREE){
					break;
				}
				np = np >> 1;
				
				if(addAndCheckBreak_w(k, komaIdx, np, list)){
					break;
				}
			}
		}
		
		// 
		{
			// Ƌʂ̂
			getUpMovePoints_w(k, orgKomaIdx, p, list);
		}
		
		// 
		{
			getDownMovePoints_w(k, orgKomaIdx, p, list);
		}
		return list;
	}
	
	
	private static boolean addAndCheckBreak_b(Kyokumen k, int komaIdx, int np, List<IchiInf> list){
		if(Bitop.existKoma_b(k, komaIdx, np)){
			return true;
		}
		
		IchiInf ichi = new IchiInf();
		ichi.komaIdx = komaIdx;
		ichi.p = np;
		list.add(ichi);
		if(Bitop.existKoma_w(k, komaIdx, np)){
			return true;
		}
		return false;
	}
	
	private static boolean addAndCheckBreak_w(Kyokumen k, int komaIdx, int np, List<IchiInf> list){
		if(Bitop.existKoma_w(k, komaIdx, np)){
			return true;
		}
		
		IchiInf ichi = new IchiInf();
		ichi.komaIdx = komaIdx;
		ichi.p = np;
		list.add(ichi);
		if(Bitop.existKoma_b(k, komaIdx, np)){
			return true;
		}
		return false;
	}
	
	public static final int cntBit(int b){
		int ret = 0;
		while(b > 0){
			int p = Integer.highestOneBit(b);
			b ^= p;
			ret++;
		}
		return ret;
	}
	
	public static List<IchiInf> getKakuMovePoints_b(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		// 
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == LEFTONE || np == LEFTTWO || np == LEFTTHREE){
					break;
				}
				if(komaIdx == 0 && np >= RIGHTTHREE){
					break;
				}
				
				if(np >= SanDanMe){
					np = np >> 17;
					komaIdx--;
				}
				else{
					np = np << 10;
				}
				if(addAndCheckBreak_b(k, komaIdx, np, list)){
					break;
				}
			}
		
		}
		
		// E
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == RIGHTONE || np == RIGHTTWO || np == RIGHTTHREE){
					break;
				}
				if(komaIdx == 0 && np >= RIGHTTHREE){
					break;
				}
				
				if(np >= SanDanMe){
					np = np >> 19;
					komaIdx--;
				}
				else{
					np = np << 8;
				}
				if(addAndCheckBreak_b(k, komaIdx, np, list)){
					break;
				}
			}
		}
		
		// 
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == LEFTONE || np == LEFTTWO || np == LEFTTHREE){
					break;
				}
				if(komaIdx == 2 && np < Bitop.NiDanMe){
					break;
				}
				
				if(np < Bitop.NiDanMe){
					np = np << 19;
					komaIdx++;
				}
				else{
					np = np >> 8;
				}
				if(addAndCheckBreak_b(k, komaIdx, np, list)){
					break;
				}
			}
		}
		
		// E
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == RIGHTONE || np == RIGHTTWO || np == RIGHTTHREE){
					break;
				}
				if(komaIdx == 0 && np >= RIGHTTHREE){
					break;
				}
				
				if(np < Bitop.NiDanMe){
					np = np << 17;
					komaIdx++;
				}
				else{
					np = np >> 10;
				}
				if(addAndCheckBreak_b(k, komaIdx, np, list)){
					break;
				}
			}
		}
		
		return list;
	}
	
	public static List<IchiInf> getKakuMovePoints_w(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		// 
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == LEFTONE || np == LEFTTWO || np == LEFTTHREE){
					break;
				}
				if(komaIdx == 0 && np >= RIGHTTHREE){
					break;
				}
				
				if(np >= SanDanMe){
					np = np >> 17;
					komaIdx--;
				}
				else{
					np = np << 10;
				}
				if(addAndCheckBreak_w(k, komaIdx, np, list)){
					break;
				}
			}
		
		}
		
		// E
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == RIGHTONE || np == RIGHTTWO || np == RIGHTTHREE){
					break;
				}
				if(komaIdx == 0 && np >= RIGHTTHREE){
					break;
				}
				
				if(np >= SanDanMe){
					np = np >> 19;
					komaIdx--;
				}
				else{
					np = np << 8;
				}
				if(addAndCheckBreak_w(k, komaIdx, np, list)){
					break;
				}
			}
		}
		
		// 
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == LEFTONE || np == LEFTTWO || np == LEFTTHREE){
					break;
				}
				if(komaIdx == 2 && np <= LEFTONE){
					break;
				}
				
				if(np < Bitop.NiDanMe){
					np = np << 19;
					komaIdx++;
				}
				else{
					np = np >> 8;
				}
				if(addAndCheckBreak_w(k, komaIdx, np, list)){
					break;
				}
			}
		}
		
		// E
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np == RIGHTONE || np == RIGHTTWO || np == RIGHTTHREE){
					break;
				}
				if(komaIdx == 0 && np >= RIGHTTHREE){
					break;
				}
				
				if(np < Bitop.NiDanMe){
					np = np << 17;
					komaIdx++;
				}
				else{
					np = np >> 10;
				}
				if(addAndCheckBreak_w(k, komaIdx, np, list)){
					break;
				}
			}
		}
		
		return list;
	}
	
	
	public static List<IchiInf> getFuMovePoints_b(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		// 
		addUp_b(p, orgKomaIdx, k, list);
		return list;
	}
	
	public static List<IchiInf> getFuMovePoints_w(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		// 
		addDown_w(p, orgKomaIdx, k, list);
		return list;
	}
	
	public static final List<IchiInf> getGinMovePoints_b(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		// 
		addUp_b(p, orgKomaIdx, k, list);
		// 
		addLeftUp_b(p, orgKomaIdx, k, list);
		// E
		addRightUp_b(p, orgKomaIdx, k, list);
		//
		addLeftDown_b(p, orgKomaIdx, k, list);
		// E
		addRightDown_b(p, orgKomaIdx, k, list);
		
		return list;
	}
	
	public static final List<IchiInf> getGinMovePoints_w(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		// 
		addDown_w(p, orgKomaIdx, k, list);
		// 
		addLeftUp_w(p, orgKomaIdx, k, list);
		// E
		addRightUp_w(p, orgKomaIdx, k, list);
		//
		addLeftDown_w(p, orgKomaIdx, k, list);
		// E
		addRightDown_w(p, orgKomaIdx, k, list);
		
		return list;
	}
	
	/**
	 * ̈ړBԂƍɋʂ̂ߊ֐
	 * @param k
	 * @param orgKomaIdx
	 * @param p
	 * @param list
	 */
	private static void getUpMovePoints_b(Kyokumen k, int orgKomaIdx, int p, List<IchiInf> list){
		// 
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np >= SanDanMe && komaIdx == 0){
					break;
				}
				if(np >= SanDanMe){
					np = np  >> 18;
					komaIdx--;
				}
				else{
					np = np << 9;
				}
				
				if(addAndCheckBreak_b(k, komaIdx, np, list)){
					break;
				}
			}
		}
	}
	
	private static void getUpMovePoints_w(Kyokumen k, int orgKomaIdx, int p, List<IchiInf> list){
		// 
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np >= SanDanMe && komaIdx == 0){
					break;
				}
				if(np >= SanDanMe){
					np = np  >> 18;
					komaIdx--;
				}
				else{
					np = np << 9;
				}
				
				if(addAndCheckBreak_w(k, komaIdx, np, list)){
					break;
				}
			}
		}
	}
	
	private static void getDownMovePoints_b(Kyokumen k, int orgKomaIdx, int p, List<IchiInf> list){
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np < NiDanMe && komaIdx == 2){
					break;
				}
				if(np < NiDanMe){
					np = np << 18;
					komaIdx++;
				}
				else{
					np = np >> 9;
				}
				
				if(addAndCheckBreak_b(k, komaIdx, np, list)){
					break;
				}
			}
		}
	}
	
	/**
	 * ̈ړBԂƍɋʂ̂ߊ֐
	 * @param k
	 * @param orgKomaIdx
	 * @param p
	 * @param list
	 */
	private static void getDownMovePoints_w(Kyokumen k, int orgKomaIdx, int p, List<IchiInf> list){
		{
			int np = p;
			int komaIdx = orgKomaIdx;
			while(true){
				if(np < NiDanMe && komaIdx == 2){
					break;
				}
				if(np < NiDanMe){
					np = np << 18;
					komaIdx++;
				}
				else{
					np = np >> 9;
				}
				
				if(addAndCheckBreak_w(k, komaIdx, np, list)){
					break;
				}
			}
		}
	}
	
	public static final List<IchiInf> getKyoMovePoints_b(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		getUpMovePoints_b(k, orgKomaIdx, p, list);
		return list;
	}
	
	public static final List<IchiInf> getKyoMovePoints_w(Kyokumen k, int orgKomaIdx, int p){
		List<IchiInf> list = new ArrayList<IchiInf>();
		getDownMovePoints_w(k, orgKomaIdx, p, list);
		return list;
	}
	
	static public final boolean existKoma_b(Kyokumen k, int komaIdx, int p){
		if(komaIdx == 0){
			return (k.b_all.ue & p) > 0;
		}
		else if(komaIdx == 1){
			return (k.b_all.mid & p) > 0;
		}
		return (k.b_all.sita & p) > 0;
	}
	
	static public final boolean existKoma_w(Kyokumen k, int komaIdx, int p){
		if(komaIdx == 0){
			return (k.w_all.ue & p) > 0;
		}
		else if(komaIdx == 1){
			return (k.w_all.mid & p) > 0;
		}
		return (k.w_all.sita & p) > 0;
	}
}
