package submit07;

import java.io.*;
import java.util.*;

import static java.lang.Math.*;
import static java.lang.Integer.*;


/*
0) 45531448147500
1) 25820849184669
2) 357989040630494
3) 311794097434304
4) 2714220229484
5) 1008958005248
6) 1638796854851040
7) 12187508399128
8) 25573191751422
9) 239580125519231

N : 407
Holes count (Cnt) = 175
Holes area (Area) = 1486741164
Score  = 45531448147500
 */


public class RectanglesAndHoles {

	static PrintStream err = System.err;
	static long progtime = 0;
	
	static int N = 0;
	Random rnd = new Random();
	static boolean debug = true;
	int debugidx = 637;
	int uplen = 0;
	int dwlen = 0;
	int lflen = 0;
	int rilen = 0;
	
	static void debug(String s){
		if(debug){
			err.print(s);
		}
	}
	static void debug(int i){
		if(debug){
			err.print(i);
		}
	}
	
	List<R> rs = null;


	
	public int[] place(int[] A, int[] B){
		long start =  System.currentTimeMillis();


		int[] ret = null;
		N = A.length;
		List<R> orgs = new ArrayList<R>();
		rs = new ArrayList<R>();

		try{
			for(int i = 0; i < N; i++){
				R r = new R(A[i], B[i]);
				r.idx = i;
				rs.add(r);
				orgs.add(r);
			}
			
			Collections.sort(rs, new Comparator<R>() {
				@Override
				public int compare(R o1, R o2) {
					return o2.l - o1.l;
				}
			});
			
			mycalc2();
			//mycalc(rs);

			ret = new int[N*3];
			for(int i = 0; i < N; i++){
				R r = orgs.get(i);
				ret[3*i] = r.x;
				ret[3*i+1] = r.y;
				ret[3*i+2] = r.d;
			}
			
		}
		catch(Exception ex){
			err.println(ex.getMessage());
		}
		
		progtime += System.currentTimeMillis() - start;
		return ret;
	}
	
	private void mycalc2() throws Exception{
		List<R> ups = new ArrayList<R>();
		List<R> dws = new ArrayList<R>();
		List<R> lfs = new ArrayList<R>();
		List<R> ris = new ArrayList<R>();
		
		List<L> upTateLines = new ArrayList<L>();
		List<L> upYokoLines = new ArrayList<L>();
		List<L> dwTateLines = new ArrayList<L>();
		List<L> dwYokoLines = new ArrayList<L>();
		List<L> lfTateLines = new ArrayList<L>();
		List<L> lfYokoLines = new ArrayList<L>();
		List<L> riTateLines = new ArrayList<L>();
		List<L> riYokoLines = new ArrayList<L>();
		
		List<R> downdowns = new ArrayList<R>();
		List<R> downlasts = new ArrayList<R>();
		List<R> upups = new ArrayList<R>();
		List<R> uplasts = new ArrayList<R>();
		List<R> leftlefts = new ArrayList<R>();
		List<R> leftlasts = new ArrayList<R>();
		List<R> rightrights = new ArrayList<R>();
		List<R> rightlasts = new ArrayList<R>();
		
		uplen = 0;
		dwlen = 0;
		lflen = 0;
		rilen = 0;
		
		List<R> lasts = new ArrayList<R>();
		for(int i = 0; i < 6; i++){
			lasts.add(rs.remove(0));
		}
		{
			R r = rs.remove(0);
			uplen = r.l;
			if(r.b > r.a){
				r.d = 1;
			}
			ups.add(r);
			upups.add(r);
		}
		{
			R r = rs.remove(0);
			dwlen = r.l;
			if(r.b > r.a){
				r.d = 1;
			}
			r.y = -r.s;
			dws.add(r);
			downdowns.add(r);
		}
		{
			R r = rs.remove(0);
			if(r.a > r.b){
				r.d = 1;
			}
			r.y = 0;
			r.x = -r.s;
			lflen += r.l;
			lfs.add(r);
			leftlefts.add(r);
		}
		{
			R r = rs.remove(0);
			if(r.a > r.b){
				r.d = 1;
			}
			r.y = rilen;
			r.x = 0;
			rilen += r.l;
			ris.add(r);
			rightrights.add(r);
		}
		
		

		while(rs.size() > 0){
			
			int next = getNextDir(uplen, dwlen, lflen, rilen);

			if(next == 0){
				calcUps(ups, upups, uplasts);
			}
			else if(next == 1){
				calcDowns(dws, downdowns, downlasts);
			}
			else if(next == 2){ // 
				calcLeft(lfs, leftlefts, leftlasts, lfTateLines, lfYokoLines);
			}
			else{
				calcRights(ris, rightrights, rightlasts);

			}
		}
		//err.println("holes : " + holes);
		
		// ŌɏdȂȂ悤ɒ
		while(uplen > dwlen){
			R r = lasts.remove(0);
			if(r.b > r.a){
				r.d = 1;
			}
			r.y = -r.s;
			r.x = dwlen;
			dwlen += r.l;
			dws.add(r);
		}
		
		while(rilen > lflen){
			R r = lasts.remove(0);
			if(r.a > r.b){
				r.d = 1;
			}
			r.y = lflen;
			r.x = -r.s;
			lflen += r.l;
			lfs.add(r);
		}
		
		
		while(lasts.size() > 0){
			if(lasts.size() >= 2){
				{
					// ŏdown
					R r = lasts.remove(0);
					if(r.b > r.a){
						r.d = 1;
					}
					r.y = -r.s;
					r.x = dwlen;
					dwlen += r.l;
					dws.add(r);
				}
				{
					R r = lasts.remove(0);
					if(r.b > r.a){
						r.d = 1;
					}
					r.y = 0;
					r.x = uplen;
					uplen += r.l;
					ups.add(r);
				}
			}
			else{
				R r = lasts.remove(0);
				if(r.b > r.a){
					r.d = 1;
				}
				r.y = -r.s;
				r.x = dwlen;
				dwlen += r.l;
				dws.add(r);
			}
			if(lasts.size() >= 2){
				{
					R r = lasts.remove(0);
					if(r.a > r.b){
						r.d = 1;
					}
					r.y = lflen;
					r.x = -r.s;
					lflen += r.l;
					lfs.add(r);
				}
				{
					R r = lasts.remove(0);
					if(r.a > r.b){
						r.d = 1;
					}
					r.y = rilen;
					r.x = 0;
					rilen += r.l;
					ris.add(r);
				}
			}
			else if(lasts.size() > 0){
				R r = lasts.remove(0);
				if(r.a > r.b){
					r.d = 1;
				}
				r.y = lflen;
				r.x = -r.s;
				lflen += r.l;
				lfs.add(r);
			}
		}
		
		
		int rightXoffset = Math.min(uplen, dwlen);
		for(R r: ris){
			r.x += rightXoffset;
		}
		int upYoffset = Math.min(lflen, rilen);
		for(R r : ups){
			r.y += upYoffset;
		}
		

	}
	
	void calcUps(List<R> lineRs, List<R> uppers, List<R> lasts){
		if(rs.size() >= 4){
			
			R lastR = lineRs.get(lineRs.size()-1);
			List<R> newR = new ArrayList<R>();
			{
				R r = getLastR();
				if(r.idx == debugidx){
					err.print("");
				}
				if(r.a < r.b){
					r.d = 1;
				}
				r.y = -r.s;
				r.x = uplen;
				uplen += r.l;
				newR.add(r);
				
			}
			{
				R r = rs.remove(rs.size()-2);
				if(r.idx == debugidx){
					err.print("");
				}
				if(r.a < r.b){
					r.d = 1;
				}
				r.y = 0;
				r.x = uplen;
				uplen += r.l;
				newR.add(r);
				uppers.add(r);
			}
			{
				R r = getLastR();
				if(r.idx == debugidx){
					err.print("");
				}
				if(r.a < r.b){
					r.d = 1;
				}
				int miny = Math.min(lastR.s, newR.get(1).s);
				if(miny == newR.get(1).s){
					//Sȕ
					r.y = miny;
					r.x = newR.get(0).x;
				}
				else{
					r.y = miny;
					r.x = newR.get(1).x - r.l;
					
					R pairR = null;
					if(uppers.size() >= 3){
						pairR = uppers.get(uppers.size()-3);
					}
					if(pairR != null && pairR.x + pairR.l > r.x &&  pairR.y + pairR.s > r.y){
						if(newR.get(1).y + newR.get(1).s >= pairR.y + pairR.s){
							r.x = newR.get(1).x - r.l;
							r.y = pairR.y + pairR.s;
						}
						else{
							r.x = pairR.x + pairR.l;
							r.y = newR.get(1).y + newR.get(1).s;
						}
					}
					R saraniMaeR = null;
					if(uppers.size() >= 4){
						saraniMaeR = uppers.get(uppers.size()-4);
					}
					if(saraniMaeR != null && saraniMaeR.x+ saraniMaeR.l > r.x){
						int uppery = newR.get(1).y + newR.get(1).s; // Êقł炱ł
						if(saraniMaeR.y + saraniMaeR.s >= uppery){
							r.x = saraniMaeR.x + saraniMaeR.l;
							r.y = uppery;
						}
						else{
							r.x = newR.get(1).x - r.l;
							r.y = saraniMaeR.y + r.s;
							if(r.x < saraniMaeR.x){
								r.x = saraniMaeR.x;
							}
						}
					}
					
					
				}
				
				newR.add(newR.size()-1, r);
				uppers.add(uppers.size()-1, r);
			
			}
			lineRs.addAll(newR);
			if(rs.size() > 5 && uppers.size() >= 5){
				int cursize = uppers.size();
				R r0 = uppers.get(cursize - 5);
				R r1 = uppers.get(cursize - 4);
				R r2 = uppers.get(cursize - 3);
				R r3 = uppers.get(cursize - 2);
				R r4 = uppers.get(cursize - 1);
				if(r1.y + r1.s > r2.y + r2.s && r3.y + r3.s > r2.y + r2.s){
					R r = getLastR();
					if(r.b > r.a){
						r.d = 1;
					}
					if(r1.y + r1.s >= r3.y + r3.s){
						r.x = r1.x + r1.l;
						r.y = r3.y + r3.s;
					}
					else{
						r.x = r3.x - r.l;
						r.y = r1.y + r1.s;
					}
					R lastlast = null;
					if(lasts.size() > 0){
						lastlast = lasts.get(lasts.size()-1);
					}
					if(r.x < r0.x + r0.l || (lastlast != null && lastlast.x + lastlast.l > r.x)
							|| r4.x < r.x + r.l){
						r.x = 0;
						r.y = 0;
						r.d = 0;
						rs.add(r);
					}
					else{
						lineRs.add(lineRs.size()-1, r);
						lasts.add(r);
					}
				}
			}
		}
	
		else{
			R r = rs.remove(0);
			if(r.b > r.a){
				r.d = 1;
			}
			r.y = 0;
			r.x = uplen;
			uplen += r.l;
			lineRs.add(r);
		}
	}
	
	void calcDowns(List<R> lineRs, List<R> uppers, List<R> lasts){
		if(rs.size() >= 4){
			
			R lastR = lineRs.get(lineRs.size()-1);
			List<R> newR = new ArrayList<R>();
			{
				R r = getLastR();
				if(r.idx == debugidx){
					err.print("");
				}
				if(r.a < r.b){
					r.d = 1;
				}
				r.y = 0;
				r.x = dwlen;
				dwlen += r.l;
				newR.add(r);
			}
			{
				R r = rs.remove(rs.size()-2);
				if(r.idx == debugidx){
					err.print("");
				}
				if(r.a < r.b){
					r.d = 1;
				}
				r.y = -r.s;
				r.x = dwlen;
				dwlen += r.l;
				newR.add(r);
				uppers.add(r);
			}
			{
				R r = getLastR();
				if(r.idx == debugidx){
					err.print("");
				}
				if(r.a < r.b){
					r.d = 1;
				}
				int maxy = Math.max(newR.get(1).y, lastR.y);
				if(maxy == newR.get(1).y){ //Ŝق
					r.y = maxy - r.s;
					r.x = newR.get(0).x;
				}
				else{
					r.y = maxy - r.s;
					r.x = newR.get(1).x - r.l;
					
					R pairR = null;
					if(uppers.size() >= 3){
						pairR = uppers.get(uppers.size()-3);
					}
					if(pairR != null && pairR.x + pairR.l > r.x && pairR.y < r.y + r.s){
						if(newR.get(1).y >= pairR.y){
							r.x = pairR.x + pairR.l;
							r.y = newR.get(1).y - r.s;
						}
						else{
							r.x = newR.get(1).x - r.l;
							r.y = pairR.y - r.s;
						}
					}
					R saraniMaeR = null;
					if(uppers.size() >= 4){
						saraniMaeR = uppers.get(uppers.size()-4);
					}
					if(saraniMaeR != null && saraniMaeR.x+ saraniMaeR.l > r.x){
						int uppery = Math.min(newR.get(1).y, pairR.y);
						if(saraniMaeR.y < uppery){
							r.x = saraniMaeR.x + saraniMaeR.l;
							r.y = uppery - r.s;
						}
						else{
							r.x = newR.get(1).x - r.l;
							r.y = saraniMaeR.y - r.s;
							if(r.x < saraniMaeR.x){
								r.x = saraniMaeR.x;
							}
						}
					}
					
				}
				newR.add(newR.size()-1, r);
				uppers.add(uppers.size()-1, r);
			}
			lineRs.addAll(newR);
			
			if(rs.size() > 5 && uppers.size() >= 5){
				int cursize = uppers.size();
				R r0 = uppers.get(cursize - 5);
				R r1 = uppers.get(cursize - 4);
				R r2 = uppers.get(cursize - 3);
				R r3 = uppers.get(cursize - 2);
				R r4 = uppers.get(cursize - 1);
				if(r1.y < r2.y && r3.y < r2.y && r1.x + r1.l < r3.x){
					R r = getLastR();
					if(r.b > r.a){
						r.d = 1;
					}
					if(r1.y >= r3.y){
						r.x = r3.x - r.l;
						r.y = r1.y - r.s;
					}
					else{
						r.x = r1.x + r1.l;
						r.y = r3.y - r.s;
					}
					
					R last = null;
					if(lasts.size() > 0){
						last = lasts.get(lasts.size()-1);
					}
					if(r.x < r0.x + r0.l || (last != null && last.x + last.l > r.x)
							|| r4.x < r.x + r.l){
						r.x = 0;
						r.y = 0;
						r.d = 0;
						rs.add(r);
					}
					else{
						lineRs.add(lineRs.size()-1, r);
						lasts.add(r);
					}
				}
			}
			
			
		}
		else{
			R r = rs.remove(0);
			if(r.b > r.a){
				r.d = 1;
			}
			r.y = -r.s;
			r.x = dwlen;
			dwlen += r.l;
			lineRs.add(r);
		}
	}
	
	void calcLeft(List<R> lineRs, List<R> uppers, List<R> lasts, 
			List<L> tateLines, List<L> yokoLines){
		if(rs.size() >= 4){
			R lastR = lineRs.get(lineRs.size()-1);
			List<R> newR = new ArrayList<R>();
			{
				R r = getLastR();
				if(r.a > r.b){
					r.d = 1;
				}
				r.y = lflen;
				r.x = 0;
				lflen += r.l;
				newR.add(r);
			}
			{
				R r = rs.remove(rs.size()-2);
				if(r.a > r.b){
					r.d = 1;
				}
				r.y = lflen;
				r.x = -r.s;
				lflen += r.l;
				newR.add(r);
				uppers.add(r);
			}
			{
				R r = getLastR();
				if(r.a > r.b){
					r.d = 1;
				}
				int maxx = Math.max(newR.get(1).x, lastR.x);
				if(maxx == newR.get(1).x){
					//Ŝق
					r.y = newR.get(0).y;
					r.x = maxx-r.s;
				}
				else{
					r.y = newR.get(1).y - r.l;
					r.x = lastR.x - r.s;
					
					R pairR = null;
					if(uppers.size() >= 3){
						pairR = uppers.get(uppers.size()-3);
					}
					if(pairR != null && pairR.y + pairR.l > r.y && pairR.x < r.x + r.s){
						if(newR.get(1).x >= pairR.x){
							r.x = newR.get(1).x - r.s;
							r.y = pairR.y + pairR.l;
						}
						else{
							r.x = pairR.x - r.s;
							r.y = newR.get(1).y - r.l;
						}
					}
					R saraniMaeR = null;
					if(uppers.size() >= 4){
						saraniMaeR = uppers.get(uppers.size()-4);
					}
					if(saraniMaeR != null && saraniMaeR.y+ saraniMaeR.l > r.y){
						int upperx = Math.min(newR.get(1).x, pairR.x);
						if(saraniMaeR.x < upperx){
							r.x = upperx - r.s;
							r.y = saraniMaeR.y + saraniMaeR.l;
						}
						else{
							r.x = upperx - r.s;
							r.y = newR.get(1).y - r.l;
							if(r.y < saraniMaeR.y){
								r.y = saraniMaeR.y;
							}
						}
					}
				}
				newR.add(newR.size()-1, r);
				uppers.add(uppers.size()-1, r);
			}
			lineRs.addAll(newR);
			if(rs.size() > 5 && uppers.size() >= 5){
				int cursize = uppers.size();
				R r0 = uppers.get(cursize - 5);
				R r1 = uppers.get(cursize - 4);
				R r2 = uppers.get(cursize - 3);
				R r3 = uppers.get(cursize - 2);
				R r4 = uppers.get(cursize - 1);
				if(r1.x < r2.x && r3.x < r2.x && r3.y > r1.y + r1.l){
					R r = getLastR();
					if(r.a > r.b){
						r.d = 1;
					}
					if(r1.x > r3.x){
						r.x = r1.x - r.s;
						r.y = r3.y - r.l;	
					}
					else{
						r.x = r3.x - r.s;
						r.y = r1.y + r1.l;
					}
					R last = null;
					if(lasts.size() > 0){
						last = lasts.get(lasts.size()-1);
					}
					if(r.y < r0.y + r0.l || (last != null && last.y + last.l > r.y)
							|| r4.y < r.y + r.l ){
						r.x = 0;
						r.y = 0;
						r.d = 0;
						rs.add(r);
					}
					else{
						lineRs.add(lineRs.size()-1, r);
						lasts.add(r);
					}
				}
			}
		}
		else{
			R r = rs.remove(0);
			if(r.a > r.b){
				r.d = 1;
			}
			r.y = lflen;
			r.x = -r.s;
			lflen += r.l;
			lineRs.add(r);
		}
	}
	
	void calcRights(List<R> lineRs, List<R> uppers, List<R> lasts){
		if(rs.size() > 4){
			R lastR = lineRs.get(lineRs.size()-1);
			List<R> newR = new ArrayList<R>();
			{
				R r = getLastR();
				if(r.idx == debugidx){
					err.print("");
				}
				if(r.a > r.b){
					r.d = 1;
				}
				r.y = rilen;
				r.x = -r.s;
				rilen += r.l;
				newR.add(r);
			}
			{
				R r = rs.remove(rs.size()-2);
				if(r.idx == debugidx){
					err.print("");
				}
				if(r.a > r.b){
					r.d = 1;
				}
				r.y = rilen;
				r.x = 0;
				rilen += r.l;
				newR.add(r);
				uppers.add(r);
			}
			{
				R r = getLastR();
				if(r.idx == debugidx){
					err.print("");
				}
				if(r.a > r.b){
					r.d = 1;
				}
				int minx = Math.min(newR.get(1).x + newR.get(1).s, lastR.x + lastR.s);
				if(minx == newR.get(1).x + newR.get(1).s){ //Ŝق
					r.y = newR.get(0).y;
					r.x = minx;
				}
				else{
					r.y = newR.get(1).y - r.l;
					r.x = minx;
					
					R pairR = null;
					if(uppers.size() >= 3){
						pairR = uppers.get(uppers.size()-3);
					}
					if(pairR != null && pairR.y + pairR.l > r.y && pairR.x + pairR.s > r.x){
						if(newR.get(1).x + newR.get(1).s >  pairR.x + pairR.s){
							r.x = pairR.x + pairR.s;
							r.y = newR.get(1).y - r.l;
						}
						else{
							r.x = newR.get(1).x +  newR.get(1).s;
							r.y = pairR.y + pairR.l;
						}
					}
					R saraniMaeR = null;
					if(uppers.size() >= 4){
						saraniMaeR = uppers.get(uppers.size()-4);
					}
					if(saraniMaeR != null && saraniMaeR.y + saraniMaeR.l > r.y){
						int upperx = Math.max(newR.get(1).x + newR.get(1).s, pairR.x + pairR.s);
						if(saraniMaeR.x + saraniMaeR.s < upperx){
							r.x = saraniMaeR.x + saraniMaeR.s;
							r.y = newR.get(1).y - r.l;
							if(r.y < saraniMaeR.y){
								r.y = saraniMaeR.y;
							}
						}
						else{
							r.x = upperx;
							r.y = saraniMaeR.y + saraniMaeR.l;
						}
					}
				}
				newR.add(newR.size()-1, r);
				uppers.add(uppers.size()-1, r);
			}
			lineRs.addAll(newR);
			if(rs.size() > 5 && uppers.size() >= 5){
				int cursize = uppers.size();
				R r0 = uppers.get(cursize - 5);
				R r1 = uppers.get(cursize - 4);
				R r2 = uppers.get(cursize - 3);
				R r3 = uppers.get(cursize - 2);
				R r4 = uppers.get(cursize - 1);
				if(r1.x + r1.s > r2.x + r2.s && r3.x + r3.s > r2.x + r2.s && r3.y > r1.y + r1.l){
					R r = getLastR();
					if(r.a > r.b){
						r.d = 1;
					}

					if(r1.x + r1.s > r3.x + r3.s){
						r.x = r3.x + r3.s;
						r.y = r1.y + r1.l;	
					}
					else{
						r.x = r1.x + r1.s;
						r.y = r3.y - r.l;
					}
					R last = null;
					if(lasts.size() > 0){
						last = lasts.get(lasts.size()-1);
					}
					if(r.y < r0.y + r0.l || (last != null && last.y + last.l > r.y) ||
							r4.y < r.y + r.l){
						r.x = 0;
						r.y = 0;
						r.d = 0;
						rs.add(r);
					}
					else{
						lineRs.add(lineRs.size()-1, r);
						lasts.add(r);
					}
				}
			}
		}
		else{
			R r = rs.remove(0);
			if(r.a > r.b){
				r.d = 1;
			}
			r.y = rilen;
			r.x = 0;
			rilen += r.l;
			lineRs.add(r);
		}
	}
	
	
	R getLastR(){
		return rs.remove(rs.size()-1);
	}
	
	int getNextDir(int uplen, int dwlen, int lflen, int rilen){
		int minlen = Math.min(Math.min(uplen, dwlen), Math.min(lflen, rilen));
		if(uplen == minlen){
			return 0;
		}
		else if(dwlen == minlen){
			return 1;
		}
		else if(lflen == minlen){
			return 2;
		}
		return 3;
	}
	
	

	
	void addLines(List<L> tateLines, List<L> yokoLines, List<L> ls) throws Exception{
	
		for(L l : ls){
			if(l.x1 == l.x2){
				boolean ins = false;
				for(int i = 0; i < tateLines.size(); i++){
					L bl = tateLines.get(i);
					if(bl.x1 > l.x2){
						tateLines.add(i, l);
						ins = true;
						break;
					}
					else if(bl.x1 == l.x1){
						int j = i;
						for(; j < tateLines.size(); j++){
							bl = tateLines.get(j);
							if(bl.x1 != l.x1)break; 
							if(bl.y1 > l.y2){
								tateLines.add(j, l);
								ins = true;
								break;
							}
							else if( l.y1 <= bl.y1 && bl.y1 <= l.y2 || l.y1 <= bl.y2 && bl.y2 <= l.y2
									|| bl.y1 <= l.y1 && l.y1 <= bl.y2 || bl.y1 <= l.y2 && l.y2 <= bl.y2){
								ins = true;
								int maxy = Math.max(bl.y2, l.y2);
								int miny = Math.min(bl.y1, l.y1);
								bl.y2 = maxy;
								bl.y1 = miny;
								int k = j+1;
								while(k < tateLines.size()){
									L nbl = tateLines.get(k);
									if(nbl.x1 != l.x1){
										break;
									}
									if( bl.y1 <= nbl.y1 && nbl.y1 <= bl.y2 || bl.y1 <= nbl.y2 && nbl.y2 <= bl.y2
										|| nbl.y1 <= bl.y1 && bl.y1 <= nbl.y2 || nbl.y1 <= bl.y2 && bl.y2 <= nbl.y2){
										maxy = Math.max(nbl.y2, bl.y2);
										miny = Math.min(nbl.y1, bl.y1);
										bl.y2 = maxy;
										bl.y1 = miny;
										tateLines.remove(nbl);
									}
									else{
										break;
									}
								}
							}
							else if(bl.y2 < l.y1){
								ins = true;
								tateLines.add(j+1, l);
							}
							
						}
						if(!ins){
							throw new Exception("unexpected");
						}
						break;
					}
				}
				if(!ins){
					tateLines.add(l);
				}
			}
			else{ //l.y1 == l.y2
				boolean ins = false;
				for(int i = 0; i < yokoLines.size(); i++){
					L bl = yokoLines.get(i);
					if(bl.y1 > l.y2){
						yokoLines.add(i, l);
						ins = true;
						break;
					}
					else if(bl.y1 == l.y1){
						int j = i;
						for(; j < yokoLines.size(); j++){
							bl = yokoLines.get(j);
							if(bl.y1 != l.y1)break; 
							if(bl.x1 > l.x2){
								yokoLines.add(j, l);
								ins = true;
								break;
							}
							else if( l.x1 <= bl.x1 && bl.x1 <= l.x2 || l.x1 <= bl.x2 && bl.x2 <= l.x2
									|| bl.x1 <= l.x1 && l.x1 <= bl.x2 || bl.x1 <= l.x2 && l.x2 <= bl.x2){
								ins = true;
								int maxx = Math.max(bl.x2, l.x2);
								int minx = Math.min(bl.x1, l.x1);
								bl.x2 = maxx;
								bl.x1 = minx;
								int k = j+1;
								while(k < yokoLines.size()){
									L nbl = yokoLines.get(k);
									if(nbl.y1 != l.y1){
										break;
									}
									if( bl.x1 <= nbl.x1 && nbl.x1 <= bl.x2 || bl.x1 <= nbl.x2 && nbl.x2 <= bl.x2
											|| nbl.x1 <= bl.x1 && bl.x1 <= nbl.x2 || nbl.x1 <= bl.x2 && bl.x2 <= nbl.x2){
										maxx = Math.max(nbl.x2, bl.x2);
										minx = Math.min(nbl.x1, bl.x1);
										bl.x2 = maxx;
										bl.x1 = minx;
										yokoLines.remove(nbl);
									}
									else{
										break;
									}
								}
							}
							else if(bl.x2 < l.x1){
								ins = true;
								yokoLines.add(j+1, l);
							}
							
						}
						if(!ins){
							throw new Exception("unexpected");
						}
						break;
					}
				}
				if(!ins){
					yokoLines.add(l);
				}
			}
		}
		
	}
	
	boolean iscrossFailure(List<L> tateLines, List<L> yokoLines, L ck){
		if(ck.x1 == ck.x2){
			int ckx = ck.x1;
			for(L l : yokoLines){
				if(l.x1 < ckx && ckx < l.x2){
					int ly = l.y1;
					if(ck.y1 < ly && ly < ck.y2){
						return true;
					}
				}
			}
		}
		else{
			int cky = ck.y1;
			for(L l : tateLines){
				int lx = l.x1;
				if(lx <= ck.x1 || lx >= ck.x2){
					continue;
				}
				if(l.y1 < cky && cky < l.y2){
					return true;
				}
			}
		}
		
		return false;
	}
	
	
	
	boolean iscrossFailure(List<L> lines, L ck){
		if(ck.x1 == ck.x2){
			int ckx = ck.x1;
			for(L l : lines){
				if(l.x1 == l.x2) continue;
				int ly = l.y1;
				if(ly <= ck.y1 || ly >= ck.y2){
					continue;
				}
				if(l.x1 < ckx && ckx < l.x2){
					return true;
				}
			}
		}
		else{
			int cky = ck.y1;
			for(L l : lines){
				if(l.y1 == l.y2) continue;
				int lx = l.x1;
				if(lx <= ck.x1 || lx >= ck.x2){
					continue;
				}
				if(l.y1 < cky && cky < l.y2){
					return true;
				}
			}
		}
		
		return false;
	}
	


	class L{
		public L(int y1, int x1, int y2, int x2){
			this.y1 = y1;
			this.x1 = x1;
			this.y2 = y2;
			this.x2 = x2;
			if(y1 == y2){
				w = x2 - x1;
			}
			else{
				w = y2 - y1;
			}
		}
		int y1 = 0;
		int x1 = 0;
		int y2 = 0;
		int x2 = 0;
		int w = 0;
	}
	
			
	
	class R{
		public R(int a, int b){
			this.a = a;
			this.b = b;
			l = Math.max(a, b);
			s = Math.min(a, b);
		}
		int a = 0;
		int b = 0;
		int l = 0;
		int s = 0;
		int idx = 0;
		int y = 0;
		int x = 0;
		int d = 0;
	}
	
	class G {
		List<R> rs = new ArrayList<R>();
		int oy = 0;
		int ox = 0;
	}

	

}
