package littlemaid.inventory;

import littlemaid.entity.EntityLittleMaid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerLittleMaid extends Container {

	protected final EntityLittleMaid maidIn;
	protected final IInventory playerInventory;
	protected final IInventory maidInventory;

	public ContainerLittleMaid(EntityPlayer player, EntityLittleMaid maid) {
		this.maidIn = maid;
		this.playerInventory = player.inventory;
		this.maidInventory = maid.inventory;
		this.maidInventory.openInventory(player);

		int j;
		int k;

		// maid inventory
		for (j = 0; j < 2; ++j)
		{
			for (k = 0; k < 9; ++k)
			{
				this.addSlotToContainer(new Slot(this.maidInventory, k + j * 9, 8 + k * 18, 76 + j * 18));
			}
		}

		// player inventory
		for (j = 0; j < 3; ++j)
		{
			for (k = 0; k < 9; ++k)
			{
				this.addSlotToContainer(new Slot(this.playerInventory, k + j * 9 + 9, 8 + k * 18, 126 + j * 18));
			}
		}

		// player active bar
		for (j = 0; j < 9; ++j)
		{
			this.addSlotToContainer(new Slot(this.playerInventory, j, 8 + j * 18, 184));
		}

		// maid armor
		for (int j1 = 0; j1 < 3; j1++) {
			final int armorIndex = 1 + j1; // ヘルメットはない
			this.addSlotToContainer(new Slot(this.maidInventory, this.maidInventory.getSizeInventory() - 4 + armorIndex, 8, 8 + j1 * 18)
			{
				/**
				 * Returns the maximum stack size for a given slot (usually the same as getInventoryStackLimit(), but 1
				 * in the case of armor slots)
				 */
				public int getSlotStackLimit()
				{
					return 1;
				}

				/**
				 * Check if the stack is a valid item for this slot. Always true beside for the armor slots.
				 */
				public boolean isItemValid(ItemStack par1ItemStack)
				{
					if (par1ItemStack == null) return false;
					return par1ItemStack.getItem().isValidArmor(par1ItemStack, armorIndex, maidIn);
				}

				/**
				 * Returns the icon index on items.png that is used as background image of the slot.
				 */
				@SideOnly(Side.CLIENT)
				public String getSlotTexture()
				{
					return ItemArmor.EMPTY_SLOT_NAMES[armorIndex];
				}
			});
		}

	}

	@Override
	public boolean canInteractWith(EntityPlayer playerIn) {
		return this.maidInventory.isUseableByPlayer(playerIn);
	}

	@Override
	public void onContainerClosed(EntityPlayer playerIn) {
		super.onContainerClosed(playerIn);
		this.maidInventory.closeInventory(playerIn);
	}

}
