package littlemaid.entity.ai;

import littlemaid.entity.EntityLittleMaid;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class EntityAIRecover extends EntityAIBase {

	private EntityLittleMaid theEntity;
	private int useSlot;

	public EntityAIRecover(EntityLittleMaid entity) {
		this.theEntity = entity;
		this.setMutexBits(0);
	}

	@Override
	public boolean shouldExecute() {
		if ((this.theEntity.getMaxHealth() - this.theEntity.getHealth()) == 0) return false;

		for (int i = 0; i < this.theEntity.inventory.getSizeInventory(); i++) {
			ItemStack stack = this.theEntity.inventory.getStackInSlot(i);
			if (stack != null && stack.getItem() == Items.sugar) {
				return true;
			}
		}
		return false;
	}

	@Override
	public void updateTask() {
		for (int i = 0; i < this.theEntity.inventory.getSizeInventory(); i++) {
			ItemStack stack = this.theEntity.inventory.getStackInSlot(i);
			if (stack != null && stack.getItem() == Items.sugar && stack.stackSize > 0) {
				this.theEntity.inventory.decrStackSize(i, 1);
				this.theEntity.setHealth(this.theEntity.getHealth() + 2);
			}
		}
	}

}
