package littlemaid.entity.ai;

import littlemaid.entity.EntityLittleMaid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;

public class EntityAIOwnerHurtTarget extends EntityAITarget {

    EntityLittleMaid theEntityMaid;
    EntityLivingBase theTarget;
    private int lastAttackTime;

	public EntityAIOwnerHurtTarget(EntityLittleMaid maid) {
        super(maid, false);
        this.theEntityMaid = maid;
        this.setMutexBits(1);
	}

	@Override
	public boolean shouldExecute() {
        if (!this.theEntityMaid.isContract())
        {
            return false;
        }
        else
        {
            EntityLivingBase entitylivingbase = this.theEntityMaid.getOwnerEntity();

            if (entitylivingbase == null)
            {
                return false;
            }
            else
            {
                this.theTarget = entitylivingbase.getLastAttacker();
                int i = entitylivingbase.getLastAttackerTime();
                return i != this.lastAttackTime && this.isSuitableTarget(this.theTarget, false);
            }
        }
	}

	@Override
	public void startExecuting() {
        this.taskOwner.setAttackTarget(this.theTarget);
        EntityLivingBase entitylivingbase = this.theEntityMaid.getOwnerEntity();

        if (entitylivingbase != null)
        {
            this.lastAttackTime = entitylivingbase.getLastAttackerTime();
        }

        super.startExecuting();
	}

}
