package littlemaid.entity.ai;

import littlemaid.LittleMaidCore;
import littlemaid.entity.EntityLittleMaid;
import littlemaid.entity.EnumMaidRole;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityAIPutTorch extends EntityAIBase {

	private EntityLittleMaid theMaid;
	private int waitTimer;
	private double followSpeed;
	private int torckPutMaxLightValue = 6;

	// 向いてる方向のちょっと先に松明を置く。そのちょっと先が直線距離で何ブロック先か？
	private double distance = 6;
	private BlockPos targetBlock;


	public EntityAIPutTorch(EntityLittleMaid maidIn, double dfollowSpeed) {
		this.theMaid = maidIn;
		this.followSpeed = dfollowSpeed;
		this.setMutexBits(4);
	}

	@Override
	public boolean shouldExecute() {
		/* 松明を置かない前提条件 */
		// 待機状態
		if (this.theMaid.isWaiting()) return false;
		// トーチャーじゃない
		if (!this.theMaid.getRole().equals(EnumMaidRole.TORCHER)) return false;
		// ご主人さまと同じディメンションにいない
		if (this.theMaid.dimension != this.theMaid.getOwner().dimension) return false;

		/*
			プレイヤーの見てる方向5ブロック先
			上がblockなら上へ、そこがAirなら下へで地面を探す
			中心含め周囲9マスの明るさをチェック
			7以下の明るさの所があれば松明設置（複数ある場合は明るい所を優先に設置）
		 */

		/*
			松明を綺麗に並べてもらう
			チャンク座標（posの下位4bit）
			for (int x = 0; x <= 12; x+=4)
			for (int y = 0; y <= 12; x+=4)
			IF(MOD(X+Y,8)=0,"置く","")
		 */

		/*
		 * ここではプレイヤーの数マス先に移動できるかの確認にして、
		 * updateTaskで明るさ確認と松明設置を行うようにする。
		 */

		World worldIn = this.theMaid.worldObj;
		Entity player = this.theMaid.getOwner();
		// 周囲の地面の明るさをチェック
		Vec3 offset = player.getLook(1); // ご主人様の見ている方向を取得
		offset = new Vec3(offset.xCoord, 0, offset.zCoord); // 上下角は無視する
		offset = offset.normalize(); // 距離を正規化して1にする
		/*
		// Ver.1.2
		// ご主人様の見ている方向の5ブロック先の足元の高さの場所を取得
		BlockPos putPoint = player.getPosition().add(offset.xCoord * this.distance, 0.0D, offset.zCoord * this.distance);

		// 明るさの最大値を保持する
		int maxLightValue = -1;
		BlockPos chkPos;
		Block chkBlock;
		this.targetBlock = null;

		// Airブロックからは明るさが取得できない？
		Loop:
		for (int i = 0; i < 2; i++) {
			// 5x5の範囲の場所を取得
			for (int x = -2; x <= 2; x++) {
				for (int z = -2; z <= 2; z++) {
					chkPos = putPoint.add(x, 0, z);
					chkBlock = worldIn.getBlockState(chkPos).getBlock();
					// 指定明るさ以下でなおかつ7に近い明るさのブロックを見つける
					if ((chkBlock instanceof BlockAir || chkBlock instanceof BlockBush)
						&& worldIn.getLightFromNeighbors(chkPos) <= this.torckPutMaxLightValue
						&& worldIn.getLightFromNeighbors(chkPos) > maxLightValue) {
						//LittleMaidCore.getLogger().info("Position:" + chkPos.toString() + " Block:" + chkBlock.toString()
						//	+ " LightVal:" + worldIn.getLightFromNeighbors(chkPos));

						maxLightValue = worldIn.getLightFromNeighbors(chkPos);
						this.targetBlock = chkPos;

						// 松明をおける一番明るい場所が見つかったら用はない
						if (maxLightValue == this.torckPutMaxLightValue) break Loop;
					}
				}
			}

			// 2段分上下まで許容
			if (this.targetBlock != null) {
				// 置ける場所あれば脱却
				break;
			} else if (worldIn.getBlockState(putPoint.down()).getBlock() instanceof BlockAir) {
				// 一段下に松明が置けそうなら下へシフト
				putPoint = putPoint.down();
			} else {
				// そうでなければ下へシフト
				putPoint = putPoint.up();
			}
		}
		if (targetBlock != null) {
			return true;
		}
		 */

		/*
		// Ver.2
		// 3ブロック先からスタート
		Vec3 vecFront = offset.addVector(offset.xCoord * 2, 0.0D, offset.zCoord * 2);

		for (int i = 0; i < 7; i++) {
			BlockPos putPoint = player.getPosition().add(vecFront.xCoord, 0.0D, vecFront.zCoord);
			while (worldIn.getBlockState(putPoint).getBlock() == Blocks.air) {
				putPoint = putPoint.down();
			}
			while (!(worldIn.getBlockState(putPoint).getBlock() == Blocks.air || worldIn.getBlockState(putPoint).getBlock() instanceof BlockBush)) {
				putPoint = putPoint.up();
			}

			if (worldIn.getLightFromNeighbors(putPoint) <= this.torckPutMaxLightValue) {
				targetBlock = putPoint;
			return true;
			}
			// 1ブロック延長
			vecFront = vecFront.addVector(offset.xCoord, (double)putPoint.getY(), offset.zCoord);
		}
		*/

		// Ver.3
		// 綺麗に並べる（性格差としてもいいかも）
		BlockPos putPoint = player.getPosition().add(offset.xCoord * 6, 0.0D, offset.zCoord * 6);
		for (int x = -3; x <= 3; x++) {
			for (int z = -3; z <= 3; z++) {
				if (((putPoint.getX() + x) & 15) == 0 || ((putPoint.getX() + x) & 3) == 0) {
					if (((putPoint.getZ() + z) & 15) == 0 || ((putPoint.getZ() + z) & 3) == 0) {
						if ((((putPoint.getX() + x) & 15) + ((putPoint.getZ() + z) & 15)) % 8 == 0) {
							putPoint = putPoint.add(x, 0, z);
							while (worldIn.getBlockState(putPoint).getBlock() == Blocks.air) {
								putPoint = putPoint.down();
							}
							while (!(worldIn.getBlockState(putPoint).getBlock() == Blocks.air || worldIn.getBlockState(putPoint).getBlock() instanceof BlockBush)) {
								putPoint = putPoint.up();
							}
							if (worldIn.getLightFromNeighbors(putPoint) <= this.torckPutMaxLightValue) {
								targetBlock = putPoint;
								return true;
							}
						}
					}
				}
			}
		}

		return false;
	}

	@Override
	public boolean continueExecuting() {
		// 15ブロック以上離れてる
		if (this.theMaid.getDistanceSqToEntity(this.theMaid.getOwner()) > 225.0F) return false;
		return !this.theMaid.isInWater()
			&& !this.theMaid.getNavigator().noPath()
			&& !this.theMaid.isWaiting()
			&& this.targetBlock != null;
	}

	@Override
	public void startExecuting() {
		this.waitTimer = 0;
		((PathNavigateGround) this.theMaid.getNavigator()).func_179690_a(false);
		LittleMaidCore.getLogger().info("TorchTarge:" + this.targetBlock.toString());
	}

	@Override
	public void resetTask() {
		this.targetBlock = null;
		this.theMaid.getNavigator().clearPathEntity();
		((PathNavigateGround) this.theMaid.getNavigator()).func_179690_a(true);
	}

	@Override
	public void updateTask() {
		this.theMaid.getLookHelper().setLookPosition((double)this.targetBlock.getX(), (double)this.targetBlock.getY(), (double)this.targetBlock.getZ(), 10.0F, (float) this.theMaid.getVerticalFaceSpeed());

		if (!this.theMaid.isWaiting() && this.targetBlock != null)
		{
			if (--this.waitTimer <= 0) // 10ループに1回くらいの頻度で
			{
				this.waitTimer = 10;

				if (this.theMaid.getPosition().distanceSq((double)this.targetBlock.getX(), (double)this.targetBlock.getY(), (double)this.targetBlock.getZ()) <= 4.0D) {
					//LittleMaidCore.getLogger().info("Place:" + this.targetBlock.toString() + " CanPlace:" + Blocks.torch.canPlaceBlockAt(this.theMaid.worldObj, this.targetBlock));

					// 松明をおいたBlockStateを作って、ワールドの該当場所のBlockStateに上書き？
					IBlockState bState = Blocks.torch.onBlockPlaced(this.theMaid.worldObj, this.targetBlock, EnumFacing.UP, 0, 0, 0, 0, this.theMaid);
					this.theMaid.worldObj.setBlockState(this.targetBlock, bState);

					this.targetBlock = null;
					return;
				}

				if (!this.theMaid.getNavigator().tryMoveToXYZ((double)this.targetBlock.getX(), (double)this.targetBlock.getY(), (double)this.targetBlock.getZ(), this.followSpeed))
				{
					/*
					if (!this.theMaid.getLeashed())
					{
						if (this.theMaid.getDistanceSq(this.targetBlock) >= 4.0D)
						{
							int i = MathHelper.floor_double(this.targetBlock.getX()) - 2;
							int j = MathHelper.floor_double(this.targetBlock.getZ()) - 2;
							int k = MathHelper.floor_double(this.targetBlock.getY());

							for (int l = 0; l <= 4; ++l)
							{
								for (int i1 = 0; i1 <= 4; ++i1)
								{
									if ((l < 1 || i1 < 1 || l > 3 || i1 > 3)
										&& World.doesBlockHaveSolidTopSurface(this.theMaid.worldObj, new BlockPos(i + l, k - 1, j + i1))
										&& !this.theMaid.worldObj.getBlockState(new BlockPos(i + l, k, j + i1)).getBlock().isFullCube()
										&& !this.theMaid.worldObj.getBlockState(new BlockPos(i + l, k + 1, j + i1)).getBlock().isFullCube())
									{
										this.theMaid.setLocationAndAngles((double) ((float) (i + l) + 0.5F),
											(double) k, (double) ((float) (j + i1) + 0.5F),
											this.theMaid.rotationYaw, this.theMaid.rotationPitch);
*/
										this.theMaid.getNavigator().clearPathEntity();
										return;
										/*
									}
								}
							}
						}
					}*/
				}
			}
		}
	}

}
