package littlemaid.entity.ai;

import littlemaid.entity.EntityLittleMaid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityAIFollowOwner extends EntityAIBase
{
	private EntityLittleMaid theMaid;
	private EntityLivingBase theOwner;
	private World theWorld;
	private double followSpeed;
	private PathNavigate maidPathfinder;
	private int field_75343_h;
	float maxDist; /* 最大待機距離 */
	float minDist; /* 最小待機距離 */
	private boolean field_75344_i;

	public EntityAIFollowOwner(EntityLittleMaid maidIn, double dfollowSpeed, float fminDist, float fmaxDist)
	{
		this.theMaid = maidIn;
		this.theWorld = maidIn.worldObj;
		this.followSpeed = dfollowSpeed;
		this.maidPathfinder = maidIn.getNavigator();
		this.minDist = fminDist;
		this.maxDist = fmaxDist;
		this.setMutexBits(2);

		if (!(maidIn.getNavigator() instanceof PathNavigateGround)) { throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal"); }
	}

	@Override
	/**
	 * Returns whether the EntityAIBase should begin execution.
	 */
	public boolean shouldExecute()
	{
		EntityLivingBase entitylivingbase = this.theMaid.getOwnerEntity();

		if (entitylivingbase == null)
		{
			return false;
		}
		else if (this.theMaid.isWaiting())
		{
			return false;
		}
		else if (this.theMaid.getDistanceSqToEntity(entitylivingbase) < (double) (this.minDist * this.minDist))
		{
			return false;
		}
		else
		{
			this.theOwner = entitylivingbase;
			return true;
		}
	}

	/**
	 * Returns whether an in-progress EntityAIBase should continue executing
	 */
	public boolean continueExecuting()
	{
		return !this.maidPathfinder.noPath()
			&& this.theMaid.getDistanceSqToEntity(this.theOwner) > (double) (this.maxDist * this.maxDist)
			&& !this.theMaid.isWaiting();
	}

	/**
	 * Execute a one shot task or start executing a continuous task
	 */
	public void startExecuting()
	{
		this.field_75343_h = 0;
		// 下の2つは同じプロパティのgetとset。何に使ってるのかはイマイチわからない。
		this.field_75344_i = ((PathNavigateGround) this.theMaid.getNavigator()).func_179689_e();
		((PathNavigateGround) this.theMaid.getNavigator()).func_179690_a(false);
	}

	/**
	 * Resets the task
	 */
	public void resetTask()
	{
		this.theOwner = null;
		this.maidPathfinder.clearPathEntity();
		((PathNavigateGround) this.theMaid.getNavigator()).func_179690_a(true);
	}

	/**
	 * Updates the task
	 */
	public void updateTask()
	{
		this.theMaid.getLookHelper().setLookPositionWithEntity(this.theOwner, 10.0F, (float) this.theMaid.getVerticalFaceSpeed());

		if (!this.theMaid.isWaiting())
		{
			if (--this.field_75343_h <= 0)
			{
				this.field_75343_h = 10;

				if (!this.maidPathfinder.tryMoveToEntityLiving(this.theOwner, this.followSpeed)) // ご主人さまへのルートが見えない
				{
					if (!this.theMaid.getLeashed()) // 繋がれていない
					{
						if (this.theMaid.getDistanceSqToEntity(this.theOwner) >= 81.0D) // 9ブロック以上離れてる
						{
							int i = MathHelper.floor_double(this.theOwner.posX) - 2;
							int j = MathHelper.floor_double(this.theOwner.posZ) - 2;
							int k = MathHelper.floor_double(this.theOwner.getEntityBoundingBox().minY);

							for (int l = 0; l <= 4; ++l)
							{
								for (int i1 = 0; i1 <= 4; ++i1)
								{
									if ((l < 1 || i1 < 1 || l > 3 || i1 > 3)
										&& World.doesBlockHaveSolidTopSurface(this.theWorld, new BlockPos(i + l, k - 1, j + i1))
										&& !this.theWorld.getBlockState(new BlockPos(i + l, k, j + i1)).getBlock().isFullCube()
										&& !this.theWorld.getBlockState(new BlockPos(i + l, k + 1, j + i1)).getBlock().isFullCube())
									{
										this.theMaid.setLocationAndAngles((double) ((float) (i + l) + 0.5F),
											(double) k, (double) ((float) (j + i1) + 0.5F),
											this.theMaid.rotationYaw, this.theMaid.rotationPitch);
										this.maidPathfinder.clearPathEntity();
										return;
									}
								}
							}
						}
					}
				}
			}
		}
	}
}