package littlemaid.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class LayerMaidHeldItem implements LayerRenderer {

	private final RenderLittleMaid maidIn;

	public LayerMaidHeldItem(RenderLittleMaid maid) {
		this.maidIn = maid;
	}

	public void doRenderLayer(EntityLivingBase entity, float distance, float intensity, float partialTicks, float livingTime, float headRotateYaw, float headRotatePitch, float scale) {
		ItemStack itemstack = entity.getHeldItem();

		if (itemstack != null)
		{
			// 現在の変換行列を保存（現状の設定を退避）
			GlStateManager.pushMatrix();

			// 下に8ドット分ずらす（回転軸を腕に合わせる）
			GlStateManager.translate(0.0F, 8.0F * scale, 0.0F);

			// 手持ちアイテムの位置を腕に同期させるために、腕の移動状態を読み込む
			((ModelBiped) this.maidIn.getMainModel()).postRenderArm(scale);

			// 手持ちアイテムの描画位置を調整
			// オブジェクトの平行移動 x(+右), y(+下), z(+後)･･･左に1ドット、下に4.8ドット、後ろに1ドットずらしている
			GlStateManager.translate(-0.0625F, 0.3F, 0.0625F);

			// 手持ちアイテムを回転させる angle回転角, x, y, z回転軸ベクトル（今回は未使用）
			// GlStateManager.rotate(-20.0F, -1.0F, 0.0F, 0.0F);

			// 手持ちアイテムの倍率を設定する（ちょっと小さめ）
			float s1 = 0.8F;
			GlStateManager.scale(s1, s1, s1);

			// 手持ちアイテムの描画
			Minecraft minecraft = Minecraft.getMinecraft();
			// オリジナルが必要としてるから使うけど、ソース見たところ、そのうちrenderItemの3つ目の引数は消えそう。
			minecraft.getItemRenderer().renderItem(entity, itemstack, ItemCameraTransforms.TransformType.THIRD_PERSON);

			// 保存していた変換行列を復帰させる（退避していた設定を復旧）
			GlStateManager.popMatrix();
		}

	}

	public boolean shouldCombineTextures() {
		return false;
	}

}
