package littlemaid.entity;

import net.minecraft.util.IStringSerializable;

public enum EnumMaidRole implements IStringSerializable {
	NONE(0, "none"),
	ATTACKER(1, "attacker"),
	TORCHER(2, "torcher"),
	PICKER(3, "picker");

    private final String name;

	private EnumMaidRole(int indexIn, String nameIn) {
		this.name = nameIn;
	}

	@Override
	public String getName() {
		return this.name;
	}

	public static EnumMaidRole getEnum(String name) {
		if (name == null) return null;

		for (EnumMaidRole role : EnumMaidRole.values()) {
			if (role.getName().equals(name)) return role;
		}
		return null;
	}

}
