/* sjctypenv.h v00.00.00.jmr
// Tests, coercions, definitions, etc., to ensure a stable environment  
// for the shift-JIS ctype character classification functions.
// Written by Joel Matthew Rees, Takino, Hyogo, Japan, September 2000. 
//   joel_rees@sannet.ne.jp
//
// Copyright 2000 Joel Matthew Rees.
//   All rights reserved.
//
// Assignment of Stewardship, or Terms of Use: 
//
// The author grants permission to use and/or redistribute the code in this 
// file, in either source or translated form, under the following conditions:
// 1. When redistributing the source code, the copyright notices and terms of 
//    use must be neither removed nor modified. 
// 2. When redistributing in a form not generally read by humans, the 
//    copyright notices and terms of use, with proper indication of elements 
//    covered, must be reproduced in the accompanying documentation and/or 
//    other materials provided with the redistribution. In addition, if the 
//    source includes statements designed to compile a copyright notice 
//    into the output object code, the redistributor is required to take 
//    such steps as necessary to preserve the notice in the translated 
//    object code.
// 3. Modifications must be annotated, with attribution, including the name(s) 
//    of the author(s) and the contributor(s) thereof, the conditions for 
//    distribution of the modification, and full indication of the date(s) 
//    and scope of the modification. Rights to the modification itself 
//    shall necessarily be retained by the author(s) thereof.
// 4. These grants shall not be construed as an assignment or assumption of 
//    liability of any sort or to any degree. Neither shall these grants be 
//    construed as endorsement or represented as such. Any party using this 
//    code in any way does so under the agreement to entirely indemnify the 
//    author and any contributors concerning the code and any use thereof. 
//    Specifically, THIS SOFTWARE IS PROVIDED AT NO COST, AS IT IS, WITHOUT 
//    ANY EXPRESS OR IMPLIED WARRANTY OF ANY SORT, INCLUDING, BUT NOT LIMITED 
//    TO, WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
//    UNDER NO CIRCUMSTANCES SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR 
//    ANY DAMAGES WHATSOEVER ARISING FROM ITS USE OR MISUSE, EVEN IF ADVISED 
//    OF THE EXISTENCE OF THE POSSIBILITY OF SUCH DAMAGE.
// 5. This code should not be used for any illegal or immoral purpose, 
//    including, but not limited to, the theft of property or services, 
//    deliberate communication of false information, the distribution of drugs 
//    for purposes other than medical, the distribution of pornography, the 
//    provision of illicit sexual services, the maintenance of oppressive 
//    governments or organizations, or the imposture of false religion and 
//    false science. 
//    Any illegal or immoral use incurs natural and legal penalties, which the 
//    author invokes in full force upon the heads of those who so use it.
// 6. Alternative redistribution arrangements:
//    a. If the above conditions are unacceptable, redistribution under the 
//       following commonly used public licenses is expressly permitted:
//       i.   The GNU General Public License (GPL) of the Free Software 
//            Foundation.
//       ii.  The Perl Artistic License, only as a part of Perl.
//       iii. The Apple Public Source License, only as a part of Darwin or 
//            a Macintosh Operating System using Darwin.
//    b. No other alternative redistribution arrangement is permitted.
//       (The original author reserves the right to add to this list.)
//    c. When redistributing this code under an alternative license, the 
//       specific license being invoked shall be noted immediately beneath 
//       the body of the terms of use. The terms of the license so specified 
//       shall apply only to the redistribution of the source so noted. 
// 7. In no case shall the rights of the original author to the original work 
//    be impaired by any distribution or redistribution arrangement.
//
// End of the Assignment of Stewardship, or terms of use.
//
// License invoked: Assignment of Stewardship.
// Notes concerning license:
//    Compiler directives are strongly encouraged as a means of meeting 
//    the attribution requirements in the Assignment of Stewardship.
*/

#ifndef SJCTYPENV_H
#define SJCTYPENV_H


#include <limits.h>


#if CHAR_BIT != 8
#	error "Need to adjust for variant definition of char!"
/* Nothing I can think of to encapsulate this issue until C provides something like 
// typedef unsigned sjisByte: 8;
*/
#endif


/* This will conflict with some poorly encapsulated programming environments.
// (Pre-compiled clots of headers probably do not promote clean programming habits, btw.)
*/
typedef unsigned char ubyte;
typedef signed char sbyte;

/* Strictly for convenience and dividing counts from booleans:
// See above about conflicts.
*/
typedef int bool;


#endif /* ifndef SJCTYPENV_H */
